/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.alignment.Patterns;
import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import java.util.Map;

public class MicrosatelliteSamplerTreeModel
extends AbstractModel {
    protected final TreeModel tree;
    protected Parameter parameter;
    protected int rootNodeNumber;
    protected int storedRootNodeNumber;
    private int[] externalValues;
    private double[] logBranchLikelihoods;
    private double[] storedLogBranchLikelihoods;
    private Patterns microsatPat;
    Map<String, Integer> taxaMap;
    boolean internalNodesChanged = false;

    public MicrosatelliteSamplerTreeModel(String string, TreeModel treeModel, Parameter parameter, Patterns patterns, int[] nArray, Map<String, Integer> map, boolean bl) {
        super(string);
        int n;
        int n2;
        this.tree = treeModel;
        this.parameter = parameter;
        this.microsatPat = patterns;
        this.externalValues = nArray;
        this.taxaMap = map;
        this.logBranchLikelihoods = new double[treeModel.getNodeCount()];
        this.storedLogBranchLikelihoods = new double[treeModel.getNodeCount()];
        this.storedRootNodeNumber = this.rootNodeNumber = treeModel.getRoot().getNumber();
        if (!bl) {
            this.initialiseInternalStates();
        }
        if ((n2 = this.parameter.getDimension()) != (n = treeModel.getInternalNodeCount())) {
            System.err.println("WARNING: setting dimension of parameter to match tree branch count");
            this.parameter.setDimension(n);
            Bounds<Double> bounds = this.parameter.getBounds();
            int n3 = (int)bounds.getUpperLimit(0).doubleValue();
            int n4 = (int)bounds.getLowerLimit(0).doubleValue();
            this.parameter.addBounds(new Parameter.DefaultBounds(n3, n4, n));
        }
        this.addModel(treeModel);
        this.addVariable(this.parameter);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        int n2 = this.getNodeNumberFromParameterIndex(n);
        NodeRef nodeRef = this.tree.getNode(n2);
        assert (nodeRef.getNumber() == n2) : "node.getNumber()=" + nodeRef.getNumber() + ", whereas nodeNumber=" + n2;
        this.internalNodesChanged = true;
        this.fireModelChanged(this, n2);
    }

    public boolean areInternalNodesChanged() {
        return this.internalNodesChanged;
    }

    public void setInternalNodesChanged(boolean bl) {
        this.internalNodesChanged = bl;
    }

    @Override
    protected void storeState() {
        this.storedRootNodeNumber = this.rootNodeNumber;
        System.arraycopy(this.logBranchLikelihoods, 0, this.storedLogBranchLikelihoods, 0, this.logBranchLikelihoods.length);
    }

    @Override
    protected void restoreState() {
        this.rootNodeNumber = this.storedRootNodeNumber;
        double[] dArray = this.logBranchLikelihoods;
        this.logBranchLikelihoods = this.storedLogBranchLikelihoods;
        this.storedLogBranchLikelihoods = dArray;
    }

    @Override
    protected void acceptState() {
    }

    public int getNodeValue(NodeRef nodeRef) {
        if (this.tree.isExternal(nodeRef)) {
            Taxon taxon = this.tree.getNodeTaxon(nodeRef);
            int n = this.taxaMap.get(taxon.getId());
            return this.externalValues[n];
        }
        int n = nodeRef.getNumber();
        int n2 = this.getParameterIndexFromNodeNumber(n);
        return (int)this.parameter.getParameterValue(n2);
    }

    public String getBranchAttributeLabel() {
        return this.parameter.getId();
    }

    public String getAttributeForBranch(NodeRef nodeRef) {
        return Double.toString(this.getNodeValue(nodeRef));
    }

    public int getNodeNumberFromParameterIndex(int n) {
        return n + this.tree.getExternalNodeCount();
    }

    public int getParameterIndexFromNodeNumber(int n) {
        return n - this.tree.getExternalNodeCount();
    }

    public TreeModel getTreeModel() {
        return this.tree;
    }

    public String[] getNodeAttributeLabel() {
        return new String[]{this.parameter.getId()};
    }

    public String[] getAttributeForNode(NodeRef nodeRef) {
        return new String[]{this.getAttributeForBranch(nodeRef)};
    }

    public double getLogBranchLikelihood(NodeRef nodeRef) {
        return this.getLogBranchLikelihood(nodeRef.getNumber());
    }

    public double getLogBranchLikelihood(int n) {
        return this.logBranchLikelihoods[n];
    }

    public void setLogBranchLikelihood(NodeRef nodeRef, double d) {
        this.logBranchLikelihoods[nodeRef.getNumber()] = d;
    }

    public double getStoredLogBranchLikelihood(int n) {
        return this.storedLogBranchLikelihoods[n];
    }

    public Patterns getMicrosatPattern() {
        return this.microsatPat;
    }

    public void initialiseInternalStates() {
        int n = this.tree.getNodeCount();
        int n2 = this.microsatPat.getDataType().getStateCount() - 1;
        int n3 = this.tree.getInternalNodeCount();
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(n2, 0.0, n3);
        for (int i = this.tree.getExternalNodeCount(); i < n; ++i) {
            NodeRef nodeRef = this.tree.getNode(i);
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
            NodeRef nodeRef3 = this.tree.getChild(nodeRef, 1);
            int n4 = this.getNodeValue(nodeRef2);
            int n5 = this.getNodeValue(nodeRef3);
            int n6 = n4 < n2 && n5 < n2 ? (n4 + n5) / 2 : (n4 < n2 ? n4 : (n5 < n2 ? n5 : MathUtils.nextInt(n2 + 1)));
            this.parameter.setParameterValueQuietly(i - this.tree.getExternalNodeCount(), n6);
        }
        this.parameter.addBounds(defaultBounds);
    }
}

