/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import java.util.Set;

public class ParsimonyStatistic
extends TreeStatistic {
    private Tree tree = null;
    private Set leafSet = null;

    public ParsimonyStatistic(String string, Tree tree, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        this.leafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        return TreeUtils.getParsimonySteps(this.tree, this.leafSet);
    }
}

