/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.Nucleotides;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.sitemodel.GammaSiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.GTR;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PseudoCodonModel
extends AbstractModel {
    public static final String PSEUDO_CODON_MODEL = "pseudoCodonModel";
    public static final String MU = "mu";
    public static final String OMEGA = "omega";
    public static final String KAPPA = "kappa";
    public static final String FIRST_POSITION = "firstPosition";
    public static final String SECOND_POSITION = "secondPosition";
    public static final String THIRD_POSITION = "thirdPosition";
    public static XMLObjectParser PSEUDO_CODON_MODEL_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("mu", Parameter.class), new ElementRule("omega", Parameter.class), new ElementRule("kappa", Parameter.class), new ElementRule("firstPosition", GammaSiteModel.class), new ElementRule("secondPosition", GammaSiteModel.class), new ElementRule("thirdPosition", GammaSiteModel.class)};

        @Override
        public String getParserName() {
            return PseudoCodonModel.PSEUDO_CODON_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(PseudoCodonModel.MU);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(PseudoCodonModel.OMEGA);
            Parameter parameter3 = (Parameter)xMLObject.getElementFirstChild(PseudoCodonModel.KAPPA);
            GammaSiteModel gammaSiteModel = (GammaSiteModel)xMLObject.getElementFirstChild(PseudoCodonModel.FIRST_POSITION);
            GammaSiteModel gammaSiteModel2 = (GammaSiteModel)xMLObject.getElementFirstChild(PseudoCodonModel.SECOND_POSITION);
            GammaSiteModel gammaSiteModel3 = (GammaSiteModel)xMLObject.getElementFirstChild(PseudoCodonModel.THIRD_POSITION);
            if (!(gammaSiteModel.getSubstitutionModel() instanceof GTR && gammaSiteModel2.getSubstitutionModel() instanceof GTR && gammaSiteModel3.getSubstitutionModel() instanceof GTR)) {
                throw new XMLParseException("Substitution models in " + this.getParserName() + " elements must be GTRs");
            }
            GTR gTR = (GTR)gammaSiteModel.getSubstitutionModel();
            FrequencyModel frequencyModel = gTR.getFrequencyModel();
            return new PseudoCodonModel(gammaSiteModel, gammaSiteModel2, gammaSiteModel3, parameter, parameter2, parameter3, frequencyModel);
        }

        @Override
        public String getParserDescription() {
            return "This element represents the Pseudo-Codon model of nucleotide evolution.";
        }

        @Override
        public Class getReturnType() {
            return PseudoCodonModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private GammaSiteModel siteModel1;
    private GammaSiteModel siteModel2;
    private GammaSiteModel siteModel3;
    private GTR gtr1;
    private GTR gtr2;
    private GTR gtr3;
    private FrequencyModel frequencyModel;
    private boolean excludeStopCodons;
    protected Parameter muParameter = null;
    protected Parameter omegaParameter = null;
    protected Parameter kappaParameter = null;

    public PseudoCodonModel(GammaSiteModel gammaSiteModel, GammaSiteModel gammaSiteModel2, GammaSiteModel gammaSiteModel3, Parameter parameter, Parameter parameter2, Parameter parameter3, FrequencyModel frequencyModel) {
        super(PSEUDO_CODON_MODEL);
        this.gtr1 = (GTR)gammaSiteModel.getSubstitutionModel();
        this.siteModel1 = gammaSiteModel;
        this.gtr2 = (GTR)gammaSiteModel2.getSubstitutionModel();
        this.siteModel2 = gammaSiteModel2;
        this.gtr3 = (GTR)gammaSiteModel3.getSubstitutionModel();
        this.siteModel3 = gammaSiteModel3;
        if (frequencyModel.getDataType() != Nucleotides.INSTANCE) {
            throw new IllegalArgumentException("Datatypes do not match!");
        }
        this.frequencyModel = frequencyModel;
        this.addModel(this.frequencyModel);
        this.muParameter = parameter;
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(parameter);
        this.omegaParameter = parameter2;
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(parameter2);
        this.kappaParameter = parameter3;
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(parameter3);
        this.excludeStopCodons = true;
        this.calculateSubstitutionModel();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.calculateSubstitutionModel();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.calculateSubstitutionModel();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    private void calculateSubstitutionModel() {
        double d = this.omegaParameter.getParameterValue(0);
        double d2 = this.kappaParameter.getParameterValue(0);
        double d3 = this.muParameter.getParameterValue(0);
        double[] dArray = this.frequencyModel.getFrequencies();
        double d4 = dArray[0] * dArray[1];
        double d5 = dArray[0] * dArray[2];
        double d6 = dArray[0] * dArray[3];
        double d7 = dArray[1] * dArray[2];
        double d8 = dArray[1] * dArray[3];
        double d9 = dArray[2] * dArray[3];
        double[][] dArray2 = new double[3][6];
        if (this.excludeStopCodons) {
            dArray2[0][0] = d * 14.0 / 16.0 + 0.125;
            dArray2[1][0] = d;
            dArray2[2][0] = d * 5.0 / 14.0 + 0.6428571428571429;
            dArray2[0][1] = d * d2;
            dArray2[1][1] = dArray2[0][1];
            dArray2[2][1] = (d / 14.0 + 0.9285714285714286) * d2;
            dArray2[0][2] = d;
            dArray2[1][2] = dArray2[0][2];
            dArray2[2][2] = d * 5.0 / 14.0 + 0.6428571428571429;
            dArray2[0][3] = d;
            dArray2[1][3] = dArray2[0][3];
            dArray2[2][3] = d * 7.0 / 15.0 + 0.5333333333333333;
            dArray2[0][4] = (d * 11.0 / 13.0 + 0.15384615384615385) * d2;
            dArray2[1][4] = d * d2;
            dArray2[2][4] = d2;
            dArray2[0][5] = d;
            dArray2[1][5] = dArray2[0][5];
            dArray2[2][5] = d * 7.0 / 15.0 + 0.5333333333333333;
        } else {
            dArray2[0][0] = d * 14.0 / 16.0 + 0.125;
            dArray2[1][0] = d;
            dArray2[2][0] = d * 5.0 / 16.0 + 0.5625;
            dArray2[0][1] = d * d2;
            dArray2[1][1] = dArray2[0][1];
            dArray2[2][1] = (d / 16.0 + 0.8125) * d2;
            dArray2[0][2] = d * 13.0 / 16.0;
            dArray2[1][2] = d;
            dArray2[2][2] = d * 5.0 / 16.0 + 0.5625;
            dArray2[0][3] = d;
            dArray2[1][3] = dArray2[0][3];
            dArray2[2][3] = d * 7.0 / 16.0 + 0.5;
            dArray2[0][4] = (d * 11.0 / 16.0 + 0.125) * d2;
            dArray2[1][4] = d * d2;
            dArray2[2][4] = d2;
            dArray2[0][5] = d * 13.0 / 16.0;
            dArray2[1][5] = d;
            dArray2[2][5] = d * 7.0 / 16.0 + 0.5;
        }
        double d10 = dArray2[0][0] * d4 + dArray2[0][1] * d5 + dArray2[0][2] * d6 + dArray2[0][3] * d7 + dArray2[0][4] * d8 + dArray2[0][5] * d9;
        double d11 = dArray2[1][0] * d4 + dArray2[1][1] * d5 + dArray2[1][2] * d6 + dArray2[1][3] * d7 + dArray2[1][4] * d8 + dArray2[1][5] * d9;
        double d12 = dArray2[2][0] * d4 + dArray2[2][1] * d5 + dArray2[2][2] * d6 + dArray2[2][3] * d7 + dArray2[2][4] * d8 + dArray2[2][5] * d9;
        double d13 = d3 * 3.0 / (d10 + d11 + d12);
        double d14 = d13 * d10;
        double d15 = d13 * d11;
        double d16 = d13 * d12;
        this.gtr1.setAbsoluteRates(dArray2[0], 4);
        this.siteModel1.setMu(d14);
        this.gtr2.setAbsoluteRates(dArray2[1], 4);
        this.siteModel2.setMu(d15);
        this.gtr3.setAbsoluteRates(dArray2[2], 4);
        this.siteModel3.setMu(d16);
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("createElement not implemented");
    }
}

