/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.ExponentialGrowth;

public class LogisticGrowth
extends ExponentialGrowth {
    private double c;

    public LogisticGrowth() {
    }

    public LogisticGrowth(double N0, double r, double c) {
        super(N0, r);
        this.c = c;
    }

    public void setShape(double value) {
        this.c = value;
    }

    public double getShape() {
        return this.c;
    }

    public void setTime50(double time50) {
        this.c = 1.0 / (Math.exp(this.getGrowthRate() * time50) - 2.0);
    }

    public double getDemographic(double t) {
        double nZero = this.getN0();
        double r = this.getGrowthRate();
        double c = this.getShape();
        double common = Math.exp(-r * t);
        return nZero * (1.0 + c) * common / (c + common);
    }

    public double getIntensity(double t) {
        throw new UnsupportedOperationException();
    }

    public double getInverseIntensity(double x) {
        throw new UnsupportedOperationException();
    }

    public boolean hasIntegral() {
        return true;
    }

    public double getIntegral(double start, double finish) {
        double term4;
        double intervalLength = finish - start;
        double nZero = this.getN0();
        double r = this.getGrowthRate();
        double c = this.getShape();
        double expOfMinusRT = Math.exp(-r * start);
        double expOfMinusRG = Math.exp(-r * intervalLength);
        double term1 = nZero * (1.0 + c);
        assert (term1 > 0.0);
        double term2 = c * (1.0 - expOfMinusRG);
        double term3 = term1 * expOfMinusRT * r * expOfMinusRG;
        assert (term2 > 0.0 || term3 > 0.0);
        if (term3 != 0.0 && term2 == 0.0) {
            term4 = 0.0;
        } else {
            if (term3 == 0.0 && term2 == 0.0) {
                throw new RuntimeException("term3 and term2 are both zeros. N0=" + this.getN0() + " growthRate=" + this.getGrowthRate() + "c=" + c);
            }
            term4 = term2 / term3;
        }
        double term5 = intervalLength / term1;
        return term5 + term4;
    }
}

