/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.GMRFSkyrideLikelihood;
import dr.inference.model.Statistic;

public class GMRFPopSizeStatistic
extends Statistic.Abstract {
    private GMRFSkyrideLikelihood gsl;
    private double[] time;

    public GMRFPopSizeStatistic(double[] dArray, GMRFSkyrideLikelihood gMRFSkyrideLikelihood) {
        super("Popsize");
        this.gsl = gMRFSkyrideLikelihood;
        this.time = dArray;
    }

    @Override
    public String getDimensionName(int n) {
        return this.getStatisticName() + Double.toString(this.time[n]);
    }

    @Override
    public int getDimension() {
        return this.time.length;
    }

    @Override
    public double getStatisticValue(int n) {
        double[] dArray = this.gsl.getCoalescentIntervalHeights();
        double[] dArray2 = this.gsl.getPopSizeParameter().getParameterValues();
        assert (dArray2.length == dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (!(this.time[n] < dArray[i])) continue;
            return dArray2[i];
        }
        return Double.NaN;
    }
}

