/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.util.Units;
import dr.evomodel.epidemiology.SIRepidemicModel;
import dr.evoxml.util.XMLUnits;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class SIRepidemicModelParser
extends AbstractXMLObjectParser {
    public static String POPULATION_SIZE = "populationSize";
    public static String SIREPI_MODEL = "epidemicSIR";
    public static String GROWTH_RATE = "growthRate";
    public static String DOUBLING_TIME = "doublingTime";
    public static String TPEAK = "peakTime";
    public static String GAMMA = "clearanceRate";
    public static String MIN_PREVALENCE = "minPrevalence";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{XMLUnits.SYNTAX_RULES[0], new ElementRule(POPULATION_SIZE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents the present day effective population size."), new XORRule(new ElementRule(GROWTH_RATE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the rate of growth during the exponential phase. See exponentialGrowth for details."), new ElementRule(DOUBLING_TIME, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the doubling time at peak growth rate.")), new ElementRule(TPEAK, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents date at which the epidemic reached its peak (positive times indicate the peak was in the past)."), new ElementRule(GAMMA, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents the rate of loss of infectiousness."), AttributeRule.newDoubleRule(MIN_PREVALENCE)};

    @Override
    public String getParserName() {
        return SIREPI_MODEL;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Units.Type type = XMLUnits.Utils.getUnitsAttr(xMLObject);
        XMLObject xMLObject2 = xMLObject.getChild(POPULATION_SIZE);
        Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
        boolean bl = true;
        Parameter parameter2 = null;
        if (xMLObject.getChild(GROWTH_RATE) != null) {
            xMLObject2 = xMLObject.getChild(GROWTH_RATE);
            parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
        } else {
            xMLObject2 = xMLObject.getChild(DOUBLING_TIME);
            parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            bl = false;
        }
        xMLObject2 = xMLObject.getChild(TPEAK);
        Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
        xMLObject2 = xMLObject.getChild(GAMMA);
        Parameter parameter4 = (Parameter)xMLObject2.getChild(Parameter.class);
        double d = xMLObject.getDoubleAttribute(MIN_PREVALENCE);
        return new SIRepidemicModel(parameter, parameter2, parameter3, parameter4, type, bl, d);
    }

    @Override
    public String getParserDescription() {
        return "SIR epidemic model using RK.";
    }

    @Override
    public Class getReturnType() {
        return SIRepidemicModel.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

