/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.color;

import java.awt.Color;

public interface ColorScheme {
    public static final ColorScheme HEATMAP = new ColorScheme(){

        double getRampValue(double d, double d2, double d3) {
            double d4 = 0.16666666666666666;
            double d5 = 0.0;
            return (d - d2) / (d3 - d2) * (d4 - d5);
        }

        @Override
        public Color getColor(double d, double d2, double d3) {
            float f = (float)this.getRampValue(d, d2, d3);
            float f2 = 0.85f;
            float f3 = 1.0f;
            return Color.getHSBColor(f, f2, f3);
        }
    };
    public static final Ramp LINEAR = new Ramp(){

        @Override
        public int mix(double d, int n, int n2) {
            return (int)((double)n * d + (double)n2 * (1.0 - d));
        }
    };
    public static final ColorScheme WHITE_RED = new RampedColorScheme(LINEAR){

        @Override
        protected Color getMaxColor() {
            return Color.RED;
        }

        @Override
        protected Color getMinColor() {
            return Color.WHITE;
        }
    };
    public static final ColorScheme WHITE_BLUE = new RampedColorScheme(LINEAR){

        @Override
        protected Color getMaxColor() {
            return Color.BLUE;
        }

        @Override
        protected Color getMinColor() {
            return Color.WHITE;
        }
    };
    public static final ColorScheme TRANPARENT_WHITE_RED = new TransparentColorScheme(WHITE_RED){

        @Override
        protected double getTransparentValue() {
            return Double.NaN;
        }
    };
    public static final ColorScheme TRANPARENT_HEATMAP = new TransparentColorScheme(HEATMAP){

        @Override
        protected double getTransparentValue() {
            return Double.NaN;
        }
    };
    public static final ColorScheme TRANPARENT0_HEATMAP = new TransparentColorScheme(HEATMAP){

        @Override
        protected double getTransparentValue() {
            return 0.0;
        }
    };
    public static final ColorScheme TRANPARENT_HEATMAP2 = new TransparentColorScheme(new RampedColorScheme(LINEAR){

        @Override
        protected Color getMaxColor() {
            return Color.YELLOW;
        }

        @Override
        protected Color getMinColor() {
            return Color.RED;
        }
    }){

        @Override
        protected double getTransparentValue() {
            return Double.NaN;
        }
    };

    public Color getColor(double var1, double var3, double var5);

    public static abstract class TransparentColorScheme
    implements ColorScheme {
        private final ColorScheme scheme;

        TransparentColorScheme(ColorScheme colorScheme) {
            this.scheme = colorScheme;
        }

        protected abstract double getTransparentValue();

        protected Color getBaseTransparentColor() {
            return Color.WHITE;
        }

        @Override
        public Color getColor(double d, double d2, double d3) {
            if (d == this.getTransparentValue()) {
                int n = this.getBaseTransparentColor().getRGB();
                n = 0xFFFFFF & n;
                return new Color(n, true);
            }
            return this.scheme.getColor(d, d2, d3);
        }
    }

    public static abstract class RampedColorScheme
    implements ColorScheme {
        private final Ramp ramp;

        protected abstract Color getMaxColor();

        protected abstract Color getMinColor();

        private RampedColorScheme(Ramp ramp) {
            this.ramp = ramp;
        }

        @Override
        public Color getColor(double d, double d2, double d3) {
            double d4 = (d - d2) / (d3 - d2);
            int n = this.ramp.mix(d4, this.getMaxColor().getRed(), this.getMinColor().getRed());
            int n2 = this.ramp.mix(d4, this.getMaxColor().getGreen(), this.getMinColor().getGreen());
            int n3 = this.ramp.mix(d4, this.getMaxColor().getBlue(), this.getMinColor().getBlue());
            return new Color(n, n2, n3);
        }
    }

    public static interface Ramp {
        public int mix(double var1, int var3, int var4);
    }
}

