/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.AutoRegressiveNormalDistribution;
import dr.math.distributions.GaussianProcessRandomGenerator;

public class AutoRegressiveNormalDistributionModel
extends AbstractModel
implements ParametricMultivariateDistributionModel,
GaussianProcessRandomGenerator,
GradientProvider,
HessianProvider {
    private final int dim;
    private final Parameter marginal;
    private final Parameter decay;
    private AutoRegressiveNormalDistribution distribution;
    private AutoRegressiveNormalDistribution storedDistribution;
    private boolean distributionKnown;
    private boolean storedDistributionKnown;

    public AutoRegressiveNormalDistributionModel(int n, Parameter parameter, Parameter parameter2) {
        super("multivariateNormalDistributionModel");
        this.dim = n;
        this.marginal = parameter;
        this.addVariable(parameter);
        this.decay = parameter2;
        this.addVariable(parameter2);
        this.distribution = this.createNewDistribution();
        this.distributionKnown = true;
    }

    public Parameter getMeanParameter() {
        return null;
    }

    private void checkDistribution() {
        if (!this.distributionKnown) {
            this.distribution = this.createNewDistribution();
            this.distributionKnown = true;
        }
    }

    @Override
    public double logPdf(double[] dArray) {
        this.checkDistribution();
        return this.distribution.logPdf(dArray);
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    public double[] getPrecisionColumn(int n) {
        this.checkDistribution();
        return this.distribution.getPrecisionColumn(n);
    }

    @Override
    public double[] getMean() {
        return new double[this.dim];
    }

    @Override
    public String getType() {
        return this.distribution.getType();
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.distributionKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedDistribution = this.distribution;
        this.storedDistributionKnown = this.distributionKnown;
    }

    @Override
    protected void restoreState() {
        this.distributionKnown = this.storedDistributionKnown;
        this.distribution = this.storedDistribution;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[][] getPrecisionMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return null;
    }

    private AutoRegressiveNormalDistribution createNewDistribution() {
        return new AutoRegressiveNormalDistribution(this.getDimension(), this.marginal.getParameterValue(0), this.decay.getParameterValue(0));
    }

    @Override
    public double[] nextRandom() {
        this.checkDistribution();
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double logPdf(Object object) {
        this.checkDistribution();
        return this.distribution.logPdf(object);
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getGradientLogDensity(object);
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getDiagonalHessianLogDensity(object);
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getHessianLogDensity(object);
    }

    public double[] getPrecisionVectorProduct(double[] dArray) {
        this.checkDistribution();
        return this.distribution.getPrecisionVectorProduct(dArray);
    }

    public double[] getDiagonal() {
        this.checkDistribution();
        return this.distribution.getDiagonal();
    }
}

