/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;

public class CataclysmicDemographic
extends ExponentialGrowth {
    private double d;
    private double catTime;

    public CataclysmicDemographic(Units.Type type) {
        super(type);
    }

    public final double getDeclineRate() {
        return -this.d;
    }

    public void setDeclineRate(double d) {
        this.d = d;
    }

    public final double getCataclysmTime() {
        return this.catTime;
    }

    public final void setCataclysmTime(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.catTime = d;
    }

    public final void setSpikeFactor(double d) {
        this.setDeclineRate(Math.log(d) / this.catTime);
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getDeclineRate();
        if (d < this.catTime) {
            return this.getN0() * Math.exp(d * d2);
        }
        double d3 = this.getN0() * Math.exp(this.catTime * d2);
        d -= this.catTime;
        double d4 = this.getGrowthRate();
        if (d4 == 0.0) {
            return d3;
        }
        return d3 * Math.exp(-d * d4);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getDeclineRate();
        double d3 = this.getGrowthRate();
        if (d < this.catTime) {
            return (Math.exp(d * -d2) - 1.0) / this.getN0() / -d2;
        }
        double d4 = (Math.exp(this.catTime * -d2) - 1.0) / this.getN0() / -d2;
        double d5 = this.getN0() * Math.exp(this.catTime * d2);
        d -= this.catTime;
        if (d3 == 0.0) {
            return d / d5 + d4;
        }
        return (Math.exp(d * d3) - 1.0) / d5 / d3 + d4;
    }

    @Override
    public double getInverseIntensity(double d) {
        double d2 = this.getDeclineRate();
        double d3 = this.getGrowthRate();
        double d4 = (Math.exp(this.catTime * -d2) - 1.0) / this.getN0() / -d2;
        if (d < d4) {
            return -Math.log(1.0 - this.getN0() * d2 * d) / d2;
        }
        double d5 = this.getN0() * Math.exp(this.catTime * d2);
        d -= d4;
        if (d3 == 0.0) {
            return d5 * d + this.catTime;
        }
        return this.catTime + Math.log(1.0 + d5 * d * d3) / d3;
    }

    @Override
    public int getNumArguments() {
        return 4;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "d";
            }
            case 3: {
                return "t";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getDeclineRate();
            }
            case 3: {
                return this.getCataclysmTime();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setDeclineRate(d);
                break;
            }
            case 3: {
                this.setCataclysmTime(d);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public DemographicFunction getCopy() {
        CataclysmicDemographic cataclysmicDemographic = new CataclysmicDemographic(this.getUnits());
        cataclysmicDemographic.setN0(this.getN0());
        cataclysmicDemographic.setGrowthRate(this.getGrowthRate());
        cataclysmicDemographic.d = this.d;
        cataclysmicDemographic.catTime = this.catTime;
        return cataclysmicDemographic;
    }
}

