/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.TreeIntervals;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.math.Binomial;
import dr.math.MultivariateFunction;

public class Coalescent
implements MultivariateFunction,
Units {
    DemographicFunction demographicFunction = null;
    IntervalList intervals = null;

    public Coalescent(Tree tree, DemographicFunction demographicFunction) {
        this(new TreeIntervals(tree), demographicFunction);
    }

    public Coalescent(IntervalList intervalList, DemographicFunction demographicFunction) {
        this.intervals = intervalList;
        this.demographicFunction = demographicFunction;
    }

    public double calculateLogLikelihood() {
        return Coalescent.calculateLogLikelihood(this.intervals, this.demographicFunction);
    }

    public static double calculateLogLikelihood(IntervalList intervalList, DemographicFunction demographicFunction) {
        return Coalescent.calculateLogLikelihood(intervalList, demographicFunction, 0.0);
    }

    public static double calculateLogLikelihood(IntervalList intervalList, DemographicFunction demographicFunction, double d) {
        double d2 = 0.0;
        int n = intervalList.getIntervalCount();
        if (n == 0) {
            return 0.0;
        }
        double d3 = intervalList.getStartTime();
        for (int i = 0; i < n; ++i) {
            double d4 = intervalList.getInterval(i);
            double d5 = d3 + d4;
            double d6 = demographicFunction.getIntegral(d3, d5);
            if (d6 == 0.0 && d4 != 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            int n2 = intervalList.getLineageCount(i);
            double d7 = Binomial.choose2(n2);
            d2 += -d7 * d6;
            if (intervalList.getIntervalType(i) == IntervalType.COALESCENT) {
                double d8 = demographicFunction.getDemographic(d5);
                if (d4 == 0.0 || d8 * (d6 / d4) >= d) {
                    d2 -= Math.log(d8);
                } else {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            d3 = d5;
        }
        return d2;
    }

    public static double calculateAnalyticalLogLikelihood(IntervalList intervalList) {
        if (!intervalList.isCoalescentOnly()) {
            throw new IllegalArgumentException("Can only calculate analytical likelihood for pure coalescent intervals");
        }
        double d = Coalescent.getLambda(intervalList);
        int n = intervalList.getSampleCount();
        return (double)(1 - n) * Math.log(d);
    }

    private static double getLambda(IntervalList intervalList) {
        double d = 0.0;
        for (int i = 0; i < intervalList.getIntervalCount(); ++i) {
            d += intervalList.getInterval(i) * (double)intervalList.getLineageCount(i);
        }
        return d /= 2.0;
    }

    @Override
    public double evaluate(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.demographicFunction.setArgument(i, dArray[i]);
        }
        return this.calculateLogLikelihood();
    }

    @Override
    public int getNumArguments() {
        return this.demographicFunction.getNumArguments();
    }

    @Override
    public double getLowerBound(int n) {
        return this.demographicFunction.getLowerBound(n);
    }

    @Override
    public double getUpperBound(int n) {
        return this.demographicFunction.getUpperBound(n);
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.demographicFunction.setUnits(type);
    }

    @Override
    public final Units.Type getUnits() {
        return this.demographicFunction.getUnits();
    }

    public DemographicFunction getDemographicFunction() {
        return this.demographicFunction;
    }

    public IntervalList getIntervals() {
        return this.intervals;
    }
}

