/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.evomodel.antigenic.AntigenicGradientWrtParameter;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.FastMatrixParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.multidimensionalscaling.MassivelyParallelMDSImpl;
import dr.inference.multidimensionalscaling.MultiDimensionalScalingCore;
import dr.inference.multidimensionalscaling.MultiDimensionalScalingCoreImpl;
import dr.inference.multidimensionalscaling.MultiDimensionalScalingLayout;
import dr.math.MathUtils;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.util.DataTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class NewAntigenicLikelihood
extends AbstractModelLikelihood
implements Citable {
    private static final boolean USE_THRESHOLDS = true;
    private static final boolean USE_INTERVALS = true;
    public static final String ANTIGENIC_LIKELIHOOD = "newAntigenicLikelihood";
    private static final int VIRUS_STRAIN = 1;
    private static final int VIRUS_DATE = 2;
    private static final int SERUM_ISOLATE = 3;
    private static final int SERUM_STRAIN = 4;
    private static final int SERUM_DATE = 5;
    private static final int TITRE = 6;
    private final int numViruses;
    private final int numSera;
    private final int observationCount;
    private final Layout layout;
    private boolean locationsKnown;
    private boolean observationsKnown;
    private boolean internalGradientKnown;
    private boolean precisionKnown;
    private boolean savedLikelihoodKnown;
    private double savedLogLikelihood;
    private boolean savedLocationsKnown;
    private boolean savedObservationsKnown;
    private boolean savedPrecisionKnown;
    private final MultiDimensionalScalingCore mdsCore;
    private final int internalDimension;
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private final List<String> virusNames = new ArrayList<String>();
    private final List<String> serumNames = new ArrayList<String>();
    private final List<Double> virusDates = new ArrayList<Double>();
    private final List<Double> serumDates = new ArrayList<Double>();
    private final int mdsDimension;
    private final int tipDimension;
    private final int tipStartOffset;
    private final double intervalWidth;
    private final Parameter mdsPrecisionParameter;
    private final Parameter locationDriftParameter;
    private final Parameter virusDriftParameter;
    private final Parameter serumDriftParameter;
    private final MatrixParameter virusSamplingParameter;
    private final MatrixParameterInterface serumLocationsParameter;
    private final Parameter virusOffsetsParameter;
    private final Parameter serumOffsetsParameter;
    private final CompoundParameter tipTraitsParameter;
    private final int[] tipIndices;
    private final Parameter virusAviditiesParameter;
    private final Parameter serumPotenciesParameter;
    private final Parameter serumBreadthsParameter;
    private double logLikelihood = 0.0;
    private boolean likelihoodKnown = false;

    public NewAntigenicLikelihood(int n, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, MatrixParameter matrixParameter, MatrixParameterInterface matrixParameterInterface, CompoundParameter compoundParameter, Parameter parameter5, Parameter parameter6, Parameter parameter7, Parameter parameter8, Parameter parameter9, DataTable<String[]> dataTable, boolean bl, double d, double d2, int n2) {
        super(ANTIGENIC_LIKELIHOOD);
        this.intervalWidth = d;
        boolean bl2 = d > 0.0;
        MatchInfo matchInfo = NewAntigenicLikelihood.matchVirusesAndSerum(this.measurements, dataTable, this.virusNames, this.virusDates, this.serumNames, this.serumDates, bl, bl2);
        double[] dArray = NewAntigenicLikelihood.getMaxTitres(this.measurements, this.serumNames);
        this.tipTraitsParameter = compoundParameter;
        if (compoundParameter.getBounds() == null) {
            compoundParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, compoundParameter.getDimension()));
        }
        this.addVariable(compoundParameter);
        this.tipIndices = this.setupTipIndices(this.tipTraitsParameter, this.virusNames);
        this.mdsDimension = n;
        this.tipDimension = compoundParameter.getParameter(0).getDimension();
        this.tipStartOffset = n2;
        this.mdsPrecisionParameter = parameter;
        this.addVariable(parameter);
        this.locationDriftParameter = parameter2;
        if (this.locationDriftParameter != null) {
            this.addVariable(parameter2);
            if (parameter5 == null || parameter6 == null) {
                throw new IllegalArgumentException("Must also provide parameters to hold the offsets");
            }
        }
        this.virusDriftParameter = parameter3;
        if (this.virusDriftParameter != null) {
            this.addVariable(parameter3);
        }
        this.serumDriftParameter = parameter4;
        if (this.serumDriftParameter != null) {
            this.addVariable(parameter4);
        }
        this.virusSamplingParameter = matrixParameter;
        if (this.virusSamplingParameter != null) {
            this.setupLocationsParameter(matrixParameter, this.virusNames);
        }
        this.serumLocationsParameter = matrixParameterInterface;
        if (this.serumLocationsParameter != null) {
            this.setupLocationsParameter(matrixParameterInterface, this.serumNames);
        }
        this.virusOffsetsParameter = parameter5;
        if (parameter5 != null) {
            this.setupOffsetsParameter(parameter5, this.virusNames, this.virusDates, matchInfo.earliestDate, true);
        }
        this.serumOffsetsParameter = parameter6;
        if (parameter6 != null) {
            this.setupOffsetsParameter(parameter6, this.serumNames, this.serumDates, matchInfo.earliestDate, false);
        }
        this.serumPotenciesParameter = this.setupSerumPotencies(parameter7, dArray);
        this.serumBreadthsParameter = this.setupSerumBreadths(parameter8);
        this.virusAviditiesParameter = this.setupVirusAvidities(parameter9);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\tNewAntigenicLikelihood:\n");
        stringBuilder.append("\t\t").append(this.virusNames.size()).append(" viruses\n");
        stringBuilder.append("\t\t").append(this.serumNames.size()).append(" sera\n");
        stringBuilder.append("\t\t").append(this.measurements.size()).append(" assay measurements\n");
        stringBuilder.append("\t\t").append(matchInfo.thresholdCount).append(" thresholded measurements\n");
        if (bl2) {
            stringBuilder.append("\n\t\tAssuming a log 2 measurement interval width of ").append(d).append("\n");
        }
        Logger.getLogger("dr.evomodel").info(stringBuilder.toString());
        this.numViruses = this.virusNames.size();
        this.numSera = this.serumNames.size();
        this.layout = this.numViruses >= this.numSera ? new Layout.VirusXSerum(this.numViruses, this.numSera, n) : new Layout.SerumXVirus(this.numViruses, this.numSera, n);
        this.layout.sort(this.measurements, this.tipIndices);
        this.setupInitialLocations(d2);
        this.mdsCore = this.instantiateCore(n, this.layout.getMajorDim(), this.layout.getMinorDim(), false);
        this.internalDimension = this.mdsCore.getInternalDimension();
        this.observationCount = this.transferObservations();
        this.mdsCore.setNonMissingObservationCount(this.observationCount);
        this.transferLocations();
        this.transferPrecision();
        this.makeDirty();
    }

    public int getNumberOfViruses() {
        return this.numViruses;
    }

    public int getNumberOfSera() {
        return this.numSera;
    }

    public int getMdsDimension() {
        return this.mdsDimension;
    }

    public void updateParametersOnDevice() {
        if (!this.precisionKnown) {
            this.transferPrecision();
            this.precisionKnown = true;
        }
        if (!this.locationsKnown) {
            this.transferLocations();
            this.locationsKnown = true;
        }
        if (!this.observationsKnown) {
            this.transferObservations();
            this.observationsKnown = true;
        }
    }

    private double computeLogLikelihoodMds() {
        this.updateParametersOnDevice();
        this.mdsCore.makeDirty();
        return this.mdsCore.calculateLogLikelihood();
    }

    private double getAdjustedValue(Measurement measurement) {
        return this.calculateBaseline(measurement.virus, measurement.serum) - measurement.log2Titre;
    }

    private void transferPrecision() {
        double[] dArray = new double[]{this.mdsPrecisionParameter.getParameterValue(0)};
        this.mdsCore.setParameters(dArray);
    }

    private int transferObservations() {
        double[] dArray = new double[this.numViruses * this.numSera];
        Arrays.fill(dArray, Double.NaN);
        int n = 0;
        for (Measurement measurement : this.measurements) {
            int n2 = this.tipIndices[measurement.virus];
            int n3 = measurement.serum;
            if (measurement.type != MeasurementType.POINT) {
                throw new RuntimeException("Not yet implemented");
            }
            dArray[this.layout.getObservationIndex((int)n2, (int)n3)] = this.getAdjustedValue(measurement);
            ++n;
        }
        this.mdsCore.setPairwiseData(dArray);
        return n;
    }

    private void transferLocations() {
        int n;
        Parameter parameter;
        int n2;
        double[] dArray = new double[(this.numViruses + this.numSera) * this.mdsDimension];
        int n3 = this.layout.getVirusLocationOffset();
        for (n2 = 0; n2 < this.numViruses; ++n2) {
            parameter = this.tipTraitsParameter.getParameter(n2);
            for (n = 0; n < this.mdsDimension; ++n) {
                dArray[n3 + n] = parameter.getParameterValue(this.tipStartOffset + n);
            }
            if (this.locationDriftParameter != null) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + this.locationDriftParameter.getParameterValue(0) * this.virusOffsetsParameter.getParameterValue(n2);
            }
            n3 += this.mdsDimension;
        }
        n3 = this.layout.getSerumLocationOffset();
        for (n2 = 0; n2 < this.numSera; ++n2) {
            parameter = this.serumLocationsParameter.getParameter(n2);
            for (n = 0; n < this.mdsDimension; ++n) {
                dArray[n3 + n] = parameter.getParameterValue(n);
            }
            if (this.locationDriftParameter != null) {
                int n5 = n3;
                dArray[n5] = dArray[n5] + this.locationDriftParameter.getParameterValue(0) * this.serumOffsetsParameter.getParameterValue(n2);
            }
            n3 += this.mdsDimension;
        }
        this.mdsCore.updateLocation(-1, dArray);
    }

    public MultiDimensionalScalingCore getCore() {
        return this.mdsCore;
    }

    private MultiDimensionalScalingCore instantiateCore(int n, int n2, int n3, boolean bl) {
        MultiDimensionalScalingCore multiDimensionalScalingCore;
        long l = 0L;
        String string = System.getProperty("mds.required.flags");
        if (string != null) {
            l = Long.parseLong(string.trim());
        }
        if (l >= 1L) {
            System.err.println("Attempting to use a native MDS core with flag: " + l + "; may the force be with you ....");
            multiDimensionalScalingCore = new MassivelyParallelMDSImpl();
        } else {
            System.err.println("Compute mode found: " + l);
            multiDimensionalScalingCore = new MultiDimensionalScalingCoreImpl();
        }
        if (bl) {
            l |= 0x20L;
        }
        System.err.println("Initializing with flags: " + l);
        multiDimensionalScalingCore.initialize(n, new MultiDimensionalScalingLayout(n2, n3), l);
        return multiDimensionalScalingCore;
    }

    private static double[] getMaxTitres(List<Measurement> list, List<String> list2) {
        double[] dArray = new double[list2.size()];
        for (Measurement measurement : list) {
            double d = measurement.log2Titre;
            if (Double.isNaN(d)) {
                d = measurement.log2Titre;
            }
            if (!(d > dArray[measurement.serum])) continue;
            dArray[measurement.serum] = d;
        }
        return dArray;
    }

    private static MatchInfo matchVirusesAndSerum(List<Measurement> list, DataTable<String[]> dataTable, List<String> list2, List<Double> list3, List<String> list4, List<Double> list5, boolean bl, boolean bl2) {
        int n = 0;
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dataTable.getRowCount(); ++i) {
            double d2;
            boolean bl3;
            boolean bl4;
            int n2;
            double d3;
            int n3;
            double d4;
            block9: {
                String[] stringArray = dataTable.getRow(i);
                String string = stringArray[1];
                d4 = Double.parseDouble(stringArray[2]);
                n3 = list2.indexOf(string);
                if (n3 == -1) {
                    list2.add(string);
                    list3.add(d4);
                    n3 = list2.size() - 1;
                }
                String string2 = bl ? stringArray[4] : stringArray[3];
                d3 = Double.parseDouble(stringArray[5]);
                n2 = list4.indexOf(string2);
                if (n2 == -1) {
                    list4.add(string2);
                    list5.add(d3);
                    n2 = list4.size() - 1;
                }
                bl4 = false;
                bl3 = false;
                d2 = Double.NaN;
                if (stringArray[6].length() > 0) {
                    try {
                        d2 = Double.parseDouble(stringArray[6]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (stringArray[6].contains("<")) {
                            d2 = Double.parseDouble(stringArray[6].replace("<", ""));
                            bl4 = true;
                            bl3 = true;
                            ++n;
                        }
                        if (!stringArray[6].contains(">")) break block9;
                        d2 = Double.parseDouble(stringArray[6].replace(">", ""));
                        bl4 = true;
                        bl3 = false;
                        ++n;
                    }
                }
            }
            if (d3 < d) {
                d = d3;
            }
            if (d4 < d) {
                d = d4;
            }
            MeasurementType measurementType = bl4 ? MeasurementType.THRESHOLD : (bl2 ? MeasurementType.INTERVAL : MeasurementType.POINT);
            Measurement measurement = new Measurement(n3, n2, d4, d3, measurementType, d2, bl3);
            list.add(measurement);
        }
        return new MatchInfo(d, n);
    }

    private Parameter setupVirusAvidities(Parameter parameter) {
        if (parameter != null) {
            parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, Double.MIN_VALUE, 1));
            parameter.setDimension(this.virusNames.size());
            this.addVariable(parameter);
            String[] stringArray = new String[this.virusNames.size()];
            this.virusNames.toArray(stringArray);
            parameter.setDimensionNames(stringArray);
            for (int i = 0; i < this.virusNames.size(); ++i) {
                parameter.setParameterValueQuietly(i, 0.0);
            }
        }
        return parameter;
    }

    private Parameter setupSerumPotencies(Parameter parameter, double[] dArray) {
        if (parameter == null) {
            parameter = new Parameter.Default("serumPotencies");
        } else {
            parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
            this.addVariable(parameter);
        }
        parameter.setDimension(this.serumNames.size());
        String[] stringArray = new String[this.serumNames.size()];
        this.serumNames.toArray(stringArray);
        parameter.setDimensionNames(stringArray);
        for (int i = 0; i < dArray.length; ++i) {
            parameter.setParameterValueQuietly(i, dArray[i]);
        }
        return parameter;
    }

    private Parameter setupSerumBreadths(Parameter parameter) {
        if (parameter != null) {
            parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
            parameter.setDimension(this.serumNames.size());
            this.addVariable(parameter);
            String[] stringArray = new String[this.serumNames.size()];
            this.serumNames.toArray(stringArray);
            parameter.setDimensionNames(stringArray);
            for (int i = 0; i < this.serumNames.size(); ++i) {
                parameter.setParameterValueQuietly(i, 1.0);
            }
        }
        return parameter;
    }

    protected void setupLocationsParameter(MatrixParameterInterface matrixParameterInterface, List<String> list) {
        if (matrixParameterInterface instanceof MatrixParameter) {
            ((MatrixParameter)matrixParameterInterface).setColumnDimension(this.mdsDimension);
            ((MatrixParameter)matrixParameterInterface).setRowDimension(list.size());
        } else if (matrixParameterInterface instanceof FastMatrixParameter) {
            FastMatrixParameter fastMatrixParameter = (FastMatrixParameter)matrixParameterInterface;
            if (fastMatrixParameter.getRowDimension() != this.mdsDimension) {
                throw new IllegalArgumentException("Column dim must be " + this.mdsDimension);
            }
            if (fastMatrixParameter.getColumnDimension() != list.size()) {
                throw new IllegalArgumentException("Row dim must be " + list.size());
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            matrixParameterInterface.getParameter(i).setId(list.get(i));
        }
        this.addVariable(matrixParameterInterface);
    }

    private void setupOffsetsParameter(Parameter parameter, List<String> list, List<Double> list2, double d, boolean bl) {
        parameter.setDimension(list.size());
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        parameter.setDimensionNames(stringArray);
        for (int i = 0; i < list.size(); ++i) {
            Double d2 = list2.get(i) - d;
            if (d2 == null) {
                throw new IllegalArgumentException("Date missing for strain: " + list.get(i));
            }
            parameter.setParameterValue(bl ? this.tipIndices[i] : i, d2);
        }
        this.addVariable(parameter);
    }

    private int[] setupTipIndices(CompoundParameter compoundParameter, List<String> list) {
        int[] nArray = new int[list.size()];
        Arrays.fill(nArray, -1);
        int n = 0;
        while (n < compoundParameter.getParameterCount()) {
            Parameter parameter = compoundParameter.getParameter(n);
            String string = parameter.getParameterName();
            int n2 = this.findStrain(string, list);
            if (n2 != -1) {
                if (nArray[n2] != -1) {
                    throw new IllegalArgumentException("Duplicated tip name: " + string);
                }
            } else {
                throw new IllegalArgumentException("Unmatched tip name in assay data: " + string + "\nNot yet implemented.");
            }
            nArray[n2] = n++;
        }
        return nArray;
    }

    private int findStrain(String string, List<String> list) {
        int n = 0;
        for (String string2 : list) {
            if (string.equalsIgnoreCase(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void setupInitialLocations(double d) {
        int n;
        double d2;
        double d3;
        int n2;
        for (n2 = 0; n2 < this.tipTraitsParameter.getParameterCount(); ++n2) {
            d3 = 0.0;
            if (this.virusOffsetsParameter != null) {
                d3 = d * this.virusOffsetsParameter.getParameterValue(this.tipIndices[n2]);
            }
            d2 = MathUtils.nextGaussian();
            this.virusSamplingParameter.getParameter(n2).setParameterValue(0, d2 + d3);
            this.tipTraitsParameter.getParameter(this.tipIndices[n2]).setParameterValue(this.tipStartOffset, d2 + d3);
            if (this.mdsDimension <= 1) continue;
            for (n = 1; n < this.mdsDimension; ++n) {
                d2 = MathUtils.nextGaussian();
                this.virusSamplingParameter.getParameter(n2).setParameterValue(n, d2);
                this.tipTraitsParameter.getParameter(this.tipIndices[n2]).setParameterValue(this.tipStartOffset + n, d2);
            }
        }
        for (n2 = 0; n2 < this.serumLocationsParameter.getParameterCount(); ++n2) {
            d3 = 0.0;
            if (this.serumOffsetsParameter != null) {
                d3 = d * this.serumOffsetsParameter.getParameterValue(n2);
            }
            d2 = MathUtils.nextGaussian() + d3;
            this.serumLocationsParameter.getParameter(n2).setParameterValue(0, d2);
            if (this.mdsDimension <= 1) continue;
            for (n = 1; n < this.mdsDimension; ++n) {
                d2 = MathUtils.nextGaussian();
                this.serumLocationsParameter.getParameter(n2).setParameterValue(n, d2);
            }
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.virusSamplingParameter) {
            if (n != -1) {
                int n2 = n / this.tipDimension;
                if (this.tipTraitsParameter != null && this.tipIndices[n2] != -1) {
                    Parameter parameter = this.virusSamplingParameter.getParameter(n2);
                    Parameter parameter2 = this.tipTraitsParameter.getParameter(this.tipIndices[n2]);
                    int n3 = n % this.mdsDimension;
                    parameter2.setParameterValue(n3, parameter.getParameterValue(n3));
                }
            } else if (this.tipTraitsParameter != null) {
                for (int i = 0; i < this.virusSamplingParameter.getParameterCount(); ++i) {
                    Parameter parameter = this.virusSamplingParameter.getParameter(i);
                    Parameter parameter3 = this.tipTraitsParameter.getParameter(this.tipIndices[i]);
                    for (int j = 0; j < parameter3.getDimension(); ++j) {
                        parameter3.setParameterValueQuietly(j, parameter.getParameterValue(j));
                    }
                }
                this.tipTraitsParameter.fireParameterChangedEvent();
            }
            this.locationsKnown = false;
        } else if (variable == this.tipTraitsParameter) {
            this.locationsKnown = false;
        } else if (variable == this.serumLocationsParameter) {
            int n4 = n / this.mdsDimension;
            this.locationsKnown = false;
        } else if (variable == this.mdsPrecisionParameter) {
            this.precisionKnown = false;
        } else if (variable == this.locationDriftParameter) {
            this.locationsKnown = false;
        } else {
            if (variable == this.virusDriftParameter) {
                this.locationsKnown = false;
                throw new IllegalArgumentException("Not yet implemented");
            }
            if (variable == this.serumDriftParameter) {
                this.locationsKnown = false;
                throw new IllegalArgumentException("Not yet implemented");
            }
            if (variable == this.serumPotenciesParameter) {
                this.observationsKnown = false;
                throw new IllegalArgumentException("Not yet implemented");
            }
            if (variable == this.serumBreadthsParameter) {
                this.observationsKnown = false;
                throw new IllegalArgumentException("Not yet implemented");
            }
            if (variable == this.virusAviditiesParameter) {
                this.observationsKnown = false;
                throw new IllegalArgumentException("Not yet implemented");
            }
            throw new IllegalArgumentException("Not yet implemented");
        }
        this.fireModelChanged(variable, n);
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.mdsCore.storeState();
        this.savedLogLikelihood = this.logLikelihood;
        this.savedLikelihoodKnown = this.likelihoodKnown;
        this.savedLocationsKnown = this.locationsKnown;
        this.savedObservationsKnown = this.observationsKnown;
        this.savedPrecisionKnown = this.precisionKnown;
    }

    @Override
    protected void restoreState() {
        this.mdsCore.restoreState();
        this.logLikelihood = this.savedLogLikelihood;
        this.likelihoodKnown = this.savedLikelihoodKnown;
        this.locationsKnown = this.savedLocationsKnown;
        this.observationsKnown = this.savedObservationsKnown;
        this.precisionKnown = this.savedPrecisionKnown;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihoodMds();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    private double calculateBaseline(int n, int n2) {
        double d = this.serumPotenciesParameter.getParameterValue(n2);
        if (this.virusAviditiesParameter != null) {
            d += this.virusAviditiesParameter.getParameterValue(n);
        }
        return d;
    }

    @Override
    public void makeDirty() {
        this.mdsCore.makeDirty();
        this.locationsKnown = false;
        this.observationsKnown = false;
        this.precisionKnown = false;
        this.internalGradientKnown = false;
        this.likelihoodKnown = false;
    }

    public AntigenicGradientWrtParameter wrtFactory(Parameter parameter) {
        if (parameter == this.tipTraitsParameter) {
            return new AntigenicGradientWrtParameter.VirusLocations(this.numViruses, this.numSera, this.mdsDimension, this.tipTraitsParameter, this.layout, this.tipStartOffset, this.tipDimension);
        }
        if (parameter == this.serumLocationsParameter) {
            return new AntigenicGradientWrtParameter.SerumLocations(this.numViruses, this.numSera, this.mdsDimension, this.serumLocationsParameter, this.layout);
        }
        if (parameter == this.locationDriftParameter) {
            return new AntigenicGradientWrtParameter.Drift(this.numViruses, this.numSera, this.mdsDimension, this.locationDriftParameter, this.virusOffsetsParameter, this.serumOffsetsParameter, this.layout);
        }
        throw new IllegalArgumentException("Not yet implemented");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Bayesian Antigenic Cartography framework";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.BEDFORD_2015_INTEGRATING);
    }

    private static class MatchInfo {
        double earliestDate;
        int thresholdCount;

        MatchInfo(double d, int n) {
            this.earliestDate = d;
            this.thresholdCount = n;
        }
    }

    static interface Layout {
        public int getMajorDim();

        public int getMinorDim();

        public int getObservationIndex(int var1, int var2);

        public int getVirusLocationOffset();

        public int getSerumLocationOffset();

        public void sort(List<Measurement> var1, int[] var2);

        public static class SerumXVirus
        extends Base {
            SerumXVirus(int n, int n2, int n3) {
                super(n, n2, n3);
            }

            @Override
            public int getMajorDim() {
                return this.numSera;
            }

            @Override
            public int getMinorDim() {
                return this.numViruses;
            }

            @Override
            public int getObservationIndex(int n, int n2) {
                return n2 * this.numViruses + n;
            }

            @Override
            public int getVirusLocationOffset() {
                return this.numSera * this.mdsDim;
            }

            @Override
            public int getSerumLocationOffset() {
                return 0;
            }

            @Override
            Comparator<Measurement> getComparator(int[] nArray) {
                return (measurement, measurement2) -> {
                    int n = measurement.serum - measurement2.serum;
                    if (n != 0) {
                        return n;
                    }
                    return nArray[measurement.virus] - nArray[measurement2.virus];
                };
            }
        }

        public static class VirusXSerum
        extends Base {
            VirusXSerum(int n, int n2, int n3) {
                super(n, n2, n3);
            }

            @Override
            public int getMajorDim() {
                return this.numViruses;
            }

            @Override
            public int getMinorDim() {
                return this.numSera;
            }

            @Override
            public int getObservationIndex(int n, int n2) {
                return n * this.numSera + n2;
            }

            @Override
            public int getVirusLocationOffset() {
                return 0;
            }

            @Override
            public int getSerumLocationOffset() {
                return this.numViruses * this.mdsDim;
            }

            @Override
            Comparator<Measurement> getComparator(int[] nArray) {
                return (measurement, measurement2) -> {
                    int n = nArray[measurement.virus] - nArray[measurement2.virus];
                    if (n != 0) {
                        return n;
                    }
                    return measurement.serum - measurement2.serum;
                };
            }
        }

        public static abstract class Base
        implements Layout {
            final int numViruses;
            final int numSera;
            final int mdsDim;

            Base(int n, int n2, int n3) {
                this.numViruses = n;
                this.numSera = n2;
                this.mdsDim = n3;
            }

            @Override
            public void sort(List<Measurement> list, int[] nArray) {
                list.sort(this.getComparator(nArray));
            }

            abstract Comparator<Measurement> getComparator(int[] var1);
        }
    }

    private static class Measurement {
        final int virus;
        final int serum;
        final double virusDate;
        final double serumDate;
        final MeasurementType type;
        final double titre;
        final double log2Titre;
        final boolean isLowerThreshold;

        private Measurement(int n, int n2, double d, double d2, MeasurementType measurementType, double d3, boolean bl) {
            this.virus = n;
            this.serum = n2;
            this.virusDate = d;
            this.serumDate = d2;
            this.type = measurementType;
            this.titre = d3;
            this.log2Titre = Math.log(d3) / Math.log(2.0);
            this.isLowerThreshold = bl;
        }
    }

    public static enum MeasurementType {
        INTERVAL,
        POINT,
        THRESHOLD,
        MISSING;

    }
}

