/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.structure;

import dr.evolution.coalescent.structure.MetaPopulation;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

@Deprecated
public class MetaPopulationModel
extends AbstractModel
implements MetaPopulation {
    public static final String META_POPULATION_MODEL = "metaPopulationModel";
    private Statistic populationSizesStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "populationSizes";
        }

        @Override
        public int getDimension() {
            return MetaPopulationModel.this.populationCount;
        }

        @Override
        public double getStatisticValue(int n) {
            double d = MetaPopulationModel.this.demographicModels[n].getDemographicFunction().getDemographic(0.0);
            return d * MetaPopulationModel.this.getProportion(n);
        }
    };
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(DemographicModel.class, 1, 999), new ElementRule(Parameter.class, true)};

        @Override
        public String getParserName() {
            return MetaPopulationModel.META_POPULATION_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ArrayList<DemographicModel> arrayList = new ArrayList<DemographicModel>(0);
            Parameter parameter = null;
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Object object = xMLObject.getChild(i);
                if (object instanceof DemographicModel) {
                    arrayList.add((DemographicModel)object);
                    continue;
                }
                if (object instanceof Parameter) {
                    if (parameter != null) {
                        throw new Error("Allowed at most one Parameter in a MetaPopulationModel");
                    }
                    parameter = (Parameter)object;
                    continue;
                }
                throw new Error("A MetaPopulationModel may only have children of type Parameter or DemographicModel");
            }
            if (parameter == null) {
                if (arrayList.size() < 2) {
                    throw new Error("A MetaPopulationModel must have at least 2 DemographicModels (or a Parameter)");
                }
            } else if (arrayList.size() != 1) {
                throw new Error("A MetaPopulationModel with a Parameter must have exactly one DemographicModel");
            }
            return new MetaPopulationModel(arrayList, parameter);
        }

        @Override
        public String getParserDescription() {
            return "A model that represents a subdivided population.";
        }

        @Override
        public Class getReturnType() {
            return MetaPopulationModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private int populationCount;
    private Parameter populationProportions;
    private DemographicModel[] demographicModels;

    public MetaPopulationModel(ArrayList<DemographicModel> arrayList, Parameter parameter) {
        this(META_POPULATION_MODEL, arrayList, parameter);
    }

    public MetaPopulationModel(String string, ArrayList<DemographicModel> arrayList, Parameter parameter) {
        super(string);
        this.populationProportions = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
            parameter.addBounds(new Parameter.DefaultBounds(1.0, 0.0, parameter.getDimension()));
            this.populationCount = parameter.getDimension() + 1;
            for (int i = 1; i < this.populationCount; ++i) {
                arrayList.add(arrayList.get(0));
            }
            this.demographicModels = arrayList.toArray(new DemographicModel[0]);
            this.addModel(this.demographicModels[0]);
        } else {
            this.populationCount = arrayList.size();
            this.demographicModels = arrayList.toArray(new DemographicModel[0]);
            for (int i = 0; i < this.populationCount; ++i) {
                this.addModel(this.demographicModels[i]);
            }
        }
        this.addStatistic(this.populationSizesStatistic);
    }

    private double getProportion(int n) {
        if (this.populationProportions == null) {
            return 1.0;
        }
        if (n > 0) {
            return this.populationProportions.getParameterValue(n - 1);
        }
        double d = 1.0;
        for (int i = 1; i < this.populationCount; ++i) {
            d -= this.populationProportions.getParameterValue(i - 1);
        }
        return d;
    }

    @Override
    public int getPopulationCount() {
        return this.populationCount;
    }

    @Override
    public double[] getPopulationSizes(double d) {
        double[] dArray = new double[this.populationCount];
        for (int i = 0; i < this.populationCount; ++i) {
            dArray[i] = this.demographicModels[i].getDemographicFunction().getDemographic(d) * this.getProportion(i);
        }
        return dArray;
    }

    @Override
    public double getDemographic(double d, int n) {
        return this.demographicModels[n].getDemographicFunction().getDemographic(d) * this.getProportion(n);
    }

    @Override
    public double getIntegral(double d, double d2, int n) {
        double d3 = this.demographicModels[n].getDemographicFunction().getIntegral(d, d2);
        return d3 / this.getProportion(n);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.fireModelChanged();
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

