/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.xml.Reportable;

@Deprecated
public abstract class AbstractTreeLikelihood
extends AbstractModelLikelihood
implements Reportable {
    protected static final boolean COUNT_TOTAL_OPERATIONS = true;
    protected MutableTreeModel treeModel = null;
    protected int nodeCount;
    protected boolean[] updateNode;
    private double logLikelihood;
    private double storedLogLikelihood;
    protected boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;
    protected boolean hasInitialized = false;
    protected int totalOperationCount = 0;
    protected int totalMatrixUpdateCount = 0;
    protected int totalGetLogLikelihoodCount = 0;
    protected int totalModelChangedCount = 0;
    protected int totalMakeDirtyCount = 0;
    protected int totalCalculateLikelihoodCount = 0;
    protected int totalRateUpdateAllCount = 0;
    protected int totalRateUpdateSingleCount = 0;

    public AbstractTreeLikelihood(String string, MutableTreeModel mutableTreeModel) {
        super(string);
        this.treeModel = mutableTreeModel;
        this.addModel(mutableTreeModel);
        this.nodeCount = mutableTreeModel.getNodeCount();
        this.updateNode = new boolean[this.nodeCount];
        for (int i = 0; i < this.nodeCount; ++i) {
            this.updateNode[i] = true;
        }
        this.likelihoodKnown = false;
        this.hasInitialized = true;
    }

    protected void updateNode(NodeRef nodeRef) {
        ++this.totalRateUpdateSingleCount;
        this.updateNode[nodeRef.getNumber()] = true;
        this.likelihoodKnown = false;
    }

    protected void updateNodeAndChildren(NodeRef nodeRef) {
        ++this.totalRateUpdateSingleCount;
        this.updateNode[nodeRef.getNumber()] = true;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            ++this.totalRateUpdateSingleCount;
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            this.updateNode[nodeRef2.getNumber()] = true;
        }
        this.likelihoodKnown = false;
    }

    protected void updateNodeAndDescendents(NodeRef nodeRef) {
        ++this.totalRateUpdateSingleCount;
        this.updateNode[nodeRef.getNumber()] = true;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            this.updateNodeAndDescendents(nodeRef2);
        }
        this.likelihoodKnown = false;
    }

    protected void updateAllNodes() {
        ++this.totalRateUpdateAllCount;
        for (int i = 0; i < this.nodeCount; ++i) {
            this.updateNode[i] = true;
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        ++this.totalModelChangedCount;
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        ++this.totalGetLogLikelihoodCount;
        if (!this.likelihoodKnown) {
            ++this.totalCalculateLikelihoodCount;
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        ++this.totalMakeDirtyCount;
        this.likelihoodKnown = false;
        this.updateAllNodes();
    }

    public boolean isLikelihoodKnown() {
        return this.likelihoodKnown;
    }

    protected abstract double calculateLogLikelihood();

    @Override
    public String getReport() {
        if (this.hasInitialized) {
            String string = this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
            string = string + "\n  total operations = " + this.totalOperationCount + "\n  matrix updates = " + this.totalMatrixUpdateCount + "\n  model changes = " + this.totalModelChangedCount + "\n  make dirties = " + this.totalMakeDirtyCount + "\n  calculate likelihoods = " + this.totalCalculateLikelihoodCount + "\n  get likelihoods = " + this.totalGetLogLikelihoodCount + "\n  all rate updates = " + this.totalRateUpdateAllCount + "\n  partial rate updates = " + this.totalRateUpdateSingleCount;
            return string;
        }
        return this.getClass().getName() + "(uninitialized)";
    }
}

