/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovjumps;

import dr.evomodel.substmodel.DefaultEigenSystem;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.inference.markovjumps.MarkovReward;
import dr.math.Binomial;
import dr.math.GammaFunction;
import dr.math.matrixAlgebra.Vector;

public class TwoStateSericolaSeriesMarkovReward
implements MarkovReward {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG2 = false;
    private double[][][][] internalC;
    private EigenDecomposition eigenDecomposition;
    private final double[] Q;
    private final double[] r;
    private final double lambda;
    private final double[] P;
    private final int phi;
    private final int dim;
    private final double epsilon;
    private final EigenSystem eigenSystem;
    private double maxTime;

    public TwoStateSericolaSeriesMarkovReward(double[] dArray, double[] dArray2, int n) {
        this(dArray, dArray2, n, 1.0E-10);
    }

    public TwoStateSericolaSeriesMarkovReward(double[] dArray, double[] dArray2, int n, double d) {
        this.Q = dArray;
        this.r = dArray2;
        this.maxTime = 0.0;
        this.epsilon = d;
        this.dim = n;
        this.lambda = this.determineLambda();
        this.phi = n - 1;
        this.P = this.initializeP(dArray, this.lambda);
        this.eigenSystem = new DefaultEigenSystem(n);
    }

    private double[][] initializeW(int n, int n2) {
        return new double[n][n2 * n2];
    }

    private int getHfromX(double d, double d2) {
        int n = 1;
        while (d >= this.r[n] * d2) {
            ++n;
        }
        return n;
    }

    private void growC(double d, int n) {
        int n2 = this.getNfromC();
        if (d > this.maxTime) {
            n2 = this.determineNumberOfSteps(d, this.lambda) + n;
            this.maxTime = d;
        }
        if (n2 > this.getNfromC()) {
            if (n2 > 200) {
                System.err.println("Growing C to N = " + n2 + " with " + this.maxTime);
            }
            if (n2 > 500) {
                System.err.println("Warning: > 500 recursion depth in SericolaSeriesMarkovReward");
            }
            this.initializeSpace(this.phi, n2);
            this.computeChnk();
        }
    }

    private void initializeSpace(int n, int n2) {
        this.internalC = new double[n + 1][n2 + 1][n2 + 1][this.dim * this.dim];
    }

    private double[] C(int n, int n2, int n3) {
        return this.internalC[n][n2][n3];
    }

    private int getNfromC() {
        return this.internalC == null ? -1 : this.internalC[0].length - 1;
    }

    private int idx(int n, int n2) {
        return n * this.dim + n2;
    }

    private int[] getHfromX(double[] dArray, double d) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = this.getHfromX(dArray[0], d);
        }
        return nArray;
    }

    @Override
    public double computePdf(double d, double d2, int n, int n2) {
        this.growC(d2, 1);
        int n3 = n * this.dim + n2;
        double d3 = 0.0;
        int n4 = this.getNfromC() - 1;
        for (int i = 0; i <= n4; ++i) {
            d3 += this.accumulatePdf(d, i, d2, n3);
        }
        return d3;
    }

    @Override
    public double[] computePdf(double d, double d2) {
        return this.computePdf(new double[]{d}, d2)[0];
    }

    public double[][] computePdf(double[] dArray, double d) {
        this.growC(d, 1);
        double[][] dArray2 = this.initializeW(dArray.length, this.dim);
        int n = this.getNfromC() - 1;
        for (int i = 0; i <= n; ++i) {
            this.accumulatePdf(dArray2, dArray, i, d);
        }
        return dArray2;
    }

    @Override
    public double computeCdf(double d, double d2, int n, int n2) {
        return this.computeCdf(d, d2)[n * this.dim + n2];
    }

    public double[] computeCdf(double d, double d2) {
        return this.computeCdf(new double[]{d}, d2)[0];
    }

    public double[][] computeCdf(double[] dArray, double d) {
        int[] nArray = this.getHfromX(dArray, d);
        this.growC(d, 0);
        double[][] dArray2 = this.initializeW(dArray.length, this.dim);
        int n = this.getNfromC();
        for (int i = 0; i <= n; ++i) {
            this.accumulateCdf(dArray2, dArray, nArray, i, d);
        }
        return dArray2;
    }

    private double[] initializeP(double[] dArray, double d) {
        double[] dArray2 = new double[this.dim * this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                double d2 = i == j ? 1.0 : 0.0;
                dArray2[this.idx((int)i, (int)j)] = d2 + dArray[this.idx(i, j)] / d;
            }
        }
        return dArray2;
    }

    private void accumulateCdf(double[][] dArray, double[] dArray2, int[] nArray, int n, double d) {
        double d2 = Math.exp(-this.lambda * d + (double)n * (Math.log(this.lambda) + Math.log(d)) - GammaFunction.lnGamma((double)n + 1.0));
        for (int i = 0; i < dArray2.length; ++i) {
            int n2;
            double d3 = dArray2[i];
            int n3 = nArray[i];
            double d4 = (d3 - this.r[n3 - 1] * d) / ((this.r[n3] - this.r[n3 - 1]) * d);
            int n4 = this.dim * this.dim;
            double[] dArray3 = new double[n4];
            for (n2 = 0; n2 <= n; ++n2) {
                double d5 = Binomial.choose(n, n2) * Math.pow(d4, n2) * Math.pow(1.0 - d4, n - n2);
                for (int j = 0; j < n4; ++j) {
                    int n5 = j;
                    dArray3[n5] = dArray3[n5] + d5 * this.C(n3, n, n2)[j];
                }
            }
            for (n2 = 0; n2 < n4; ++n2) {
                double[] dArray4 = dArray[i];
                int n6 = n2;
                dArray4[n6] = dArray4[n6] + d2 * dArray3[n2];
            }
        }
    }

    private double accumulatePdf(double d, int n, double d2, int n2) {
        double d3 = 0.0;
        double d4 = Math.exp(-this.lambda * d2 + (double)n * (Math.log(this.lambda) + Math.log(d2)) - GammaFunction.lnGamma((double)n + 1.0));
        int n3 = 1;
        double d5 = this.lambda / (this.r[n3] - this.r[n3 - 1]);
        double d6 = (d - this.r[n3 - 1] * d2) / ((this.r[n3] - this.r[n3 - 1]) * d2);
        double d7 = 0.0;
        for (int i = 0; i <= n; ++i) {
            double d8 = Binomial.choose(n, i) * Math.pow(d6, i) * Math.pow(1.0 - d6, n - i);
            d7 += d8 * (this.C(n3, n + 1, i + 1)[n2] - this.C(n3, n + 1, i)[n2]);
        }
        return d3 += d5 * d4 * d7;
    }

    private void accumulatePdf(double[][] dArray, double[] dArray2, int n, double d) {
        double d2 = Math.exp(-this.lambda * d + (double)n * (Math.log(this.lambda) + Math.log(d)) - GammaFunction.lnGamma((double)n + 1.0));
        for (int i = 0; i < dArray2.length; ++i) {
            int n2;
            double d3 = dArray2[i];
            int n3 = 1;
            double d4 = this.lambda / (this.r[n3] - this.r[n3 - 1]);
            double d5 = (d3 - this.r[n3 - 1] * d) / ((this.r[n3] - this.r[n3 - 1]) * d);
            int n4 = this.dim * this.dim;
            double[] dArray3 = new double[n4];
            for (n2 = 0; n2 <= n; ++n2) {
                double d6 = Binomial.choose(n, n2) * Math.pow(d5, n2) * Math.pow(1.0 - d5, n - n2);
                for (int j = 0; j < n4; ++j) {
                    int n5 = j;
                    dArray3[n5] = dArray3[n5] + d6 * (this.C(n3, n + 1, n2 + 1)[j] - this.C(n3, n + 1, n2)[j]);
                }
            }
            for (n2 = 0; n2 < n4; ++n2) {
                double[] dArray4 = dArray[i];
                int n6 = n2;
                dArray4[n6] = dArray4[n6] + d4 * d2 * dArray3[n2];
            }
        }
    }

    private double relationTwelve(int n, int n2, int n3, int n4, int n5) {
        double d = (this.r[n4] - this.r[n]) / (this.r[n4] - this.r[n - 1]) * this.C(n, n2, n3 - 1)[this.idx(n4, n5)];
        double d2 = 0.0;
        for (int i = 0; i <= this.phi; ++i) {
            d2 += this.P[this.idx(n4, i)] * this.C(n, n2 - 1, n3 - 1)[this.idx(i, n5)];
        }
        return d + (d2 *= (this.r[n] - this.r[n - 1]) / (this.r[n4] - this.r[n - 1]));
    }

    private double relationThirteen(int n, int n2, int n3, int n4, int n5) {
        double d = (this.r[n - 1] - this.r[n4]) / (this.r[n] - this.r[n4]) * this.C(n, n2, n3 + 1)[this.idx(n4, n5)];
        double d2 = 0.0;
        for (int i = 0; i <= this.phi; ++i) {
            d2 += this.P[this.idx(n4, i)] * this.C(n, n2 - 1, n3)[this.idx(i, n5)];
        }
        return d + (d2 *= (this.r[n] - this.r[n - 1]) / (this.r[n] - this.r[n4]));
    }

    private double[] product(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[this.dim * this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                int n = this.idx(i, j);
                for (int k = 0; k < this.dim; ++k) {
                    int n2 = n;
                    dArray3[n2] = dArray3[n2] + dArray[this.idx(i, k)] * dArray2[this.idx(k, j)];
                }
            }
        }
        return dArray3;
    }

    private void computeChnk() {
        int n;
        int n2;
        double[] dArray = new double[this.dim * this.dim];
        for (n2 = 0; n2 < this.dim; ++n2) {
            dArray[this.idx((int)n2, (int)n2)] = 1.0;
        }
        for (n2 = 1; n2 <= this.phi; ++n2) {
            for (n = 0; n <= n2 - 1; ++n) {
                this.C((int)n2, (int)0, (int)0)[this.idx((int)n, (int)n)] = 1.0;
            }
        }
        n2 = this.getNfromC();
        for (n = 1; n <= n2; ++n) {
            int n3;
            int n4;
            int n5;
            int n6;
            for (n6 = 1; n6 <= this.phi; ++n6) {
                for (n5 = 1; n5 <= n; ++n5) {
                    for (n4 = n6; n4 <= this.phi; ++n4) {
                        for (n3 = 0; n3 <= this.phi; ++n3) {
                            this.C((int)n6, (int)n, (int)n5)[this.idx((int)n4, (int)n3)] = this.relationTwelve(n6, n, n5, n4, n3);
                        }
                    }
                }
                for (n5 = n6 + 1; n5 <= this.phi; ++n5) {
                    for (n4 = 0; n4 <= this.phi; ++n4) {
                        this.C((int)(n6 + 1), (int)n, (int)0)[this.idx((int)n5, (int)n4)] = this.C(n6, n, n)[this.idx(n5, n4)];
                    }
                }
            }
            dArray = this.product(dArray, this.P);
            for (n6 = 0; n6 <= this.phi - 1; ++n6) {
                for (n5 = 0; n5 <= this.phi; ++n5) {
                    this.C((int)this.phi, (int)n, (int)n)[this.idx((int)n6, (int)n5)] = dArray[this.idx(n6, n5)];
                }
            }
            for (n6 = this.phi; n6 >= 1; --n6) {
                for (n5 = n - 1; n5 >= 0; --n5) {
                    for (n4 = 0; n4 <= n6 - 1; ++n4) {
                        for (n3 = 0; n3 <= this.phi; ++n3) {
                            this.C((int)n6, (int)n, (int)n5)[this.idx((int)n4, (int)n3)] = this.relationThirteen(n6, n, n5, n4, n3);
                        }
                    }
                    for (n4 = 0; n4 <= n6 - 2; ++n4) {
                        for (n3 = 0; n3 <= this.phi; ++n3) {
                            this.C((int)(n6 - 1), (int)n, (int)n)[this.idx((int)n4, (int)n3)] = this.C(n6, n, 0)[this.idx(n4, n3)];
                        }
                    }
                }
            }
        }
    }

    private double determineLambda() {
        double d = this.Q[0];
        for (int i = 1; i < this.dim; ++i) {
            int n = this.idx(i, i);
            if (!(this.Q[n] < d)) continue;
            d = this.Q[n];
        }
        return -d;
    }

    private double[][] squareMatrix(double[] dArray) {
        double[][] dArray2 = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray2[i][j] = dArray[this.idx(i, j)];
            }
        }
        return dArray2;
    }

    private int determineNumberOfSteps(double d, double d2) {
        double d3;
        int n = -1;
        double d4 = 1.0 - this.epsilon;
        for (double d5 = 0.0; Math.abs(d5 - d4) > this.epsilon && d5 < 1.0; d5 += Math.exp(d3)) {
            d3 = -d2 * d + (double)(++n) * (Math.log(d2) + Math.log(d)) - GammaFunction.lnGamma(n + 1);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Q: " + new Vector(this.Q) + "\n");
        stringBuilder.append("r: " + new Vector(this.r) + "\n");
        stringBuilder.append("lambda: " + this.lambda + "\n");
        stringBuilder.append("N: " + this.getNfromC() + "\n");
        stringBuilder.append("maxTime: " + this.maxTime + "\n");
        stringBuilder.append("cprob at maxTime: " + new Vector(this.computeConditionalProbabilities(this.maxTime)) + "\n");
        return stringBuilder.toString();
    }

    private EigenDecomposition getEigenDecomposition() {
        if (this.eigenDecomposition == null) {
            this.eigenDecomposition = this.eigenSystem.decomposeMatrix(this.squareMatrix(this.Q));
        }
        return this.eigenDecomposition;
    }

    public double[] computeConditionalProbabilities(double d) {
        double[] dArray = new double[this.dim * this.dim];
        this.eigenSystem.computeExponential(this.getEigenDecomposition(), d, dArray);
        return dArray;
    }

    @Override
    public double computeConditionalProbability(double d, int n, int n2) {
        return this.eigenSystem.computeExponential(this.getEigenDecomposition(), d, n, n2);
    }
}

