/*
 * Decompiled with CFR 0.152.
 */
package dr.math.functionEval;

public final class GammaFunction {
    static double sqrt2Pi = Math.sqrt(Math.PI * 2);
    static double[] coefficients = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};

    public static double beta(double d, double d2) {
        return Math.exp(GammaFunction.logGamma(d) + GammaFunction.logGamma(d2) - GammaFunction.logGamma(d + d2));
    }

    public static long factorial(long l) {
        return l < 2L ? 1L : l * GammaFunction.factorial(l - 1L);
    }

    public static double gamma(double d) {
        return d > 1.0 ? Math.exp(GammaFunction.leadingFactor(d)) * GammaFunction.series(d) * sqrt2Pi / d : (d > 0.0 ? GammaFunction.gamma(d + 1.0) / d : Double.NaN);
    }

    private static double leadingFactor(double d) {
        double d2 = d + 5.5;
        return Math.log(d2) * (d + 0.5) - d2;
    }

    public static double logBeta(double d, double d2) {
        return GammaFunction.logGamma(d) + GammaFunction.logGamma(d2) - GammaFunction.logGamma(d + d2);
    }

    public static double logGamma(double d) {
        return d > 1.0 ? GammaFunction.leadingFactor(d) + Math.log(GammaFunction.series(d) * sqrt2Pi / d) : (d > 0.0 ? GammaFunction.logGamma(d + 1.0) - Math.log(d) : Double.NaN);
    }

    private static double series(double d) {
        double d2 = 1.000000000190015;
        double d3 = d;
        for (int i = 0; i < 6; ++i) {
            d2 += coefficients[i] / (d3 += 1.0);
        }
        return d2;
    }
}

