requireNamespace("BeeBDC")
requireNamespace("dplyr")


## test data - these have been abbreviated for sanity and also edited. And duplicated. They're not totally real
testData <- dplyr::tribble(
                     ~family,     ~subfamily,            ~genus,                    ~species, ~specificEpithet, ~taxonRank, ~typeStatus, ~decimalLatitude, ~decimalLongitude,       ~stateProvince,                                                       ~locality, ~county, ~municipality,    ~license,                                                                                                                  ~issue, ~eventDate, ~day, ~month, ~year,       ~basisOfRecord, ~country, ~type, ~occurrenceStatus,                                  ~recordedBy, ~coordinatePrecision, ~coordinateUncertaintyInMeters, ~spatiallyValid,      ~catalogNumber, ~institutionCode,       ~datasetName,            ~verbatimScientificName, ~verbatimEventDate,     ~sex, ~rights,                        ~rightsHolder, ~hasCoordinate, ~hasGeospatialIssues, ~occurrenceYear, ~duplicateStatus, ~verbatim_scientificName, ~verbatimLatitude, ~verbatimLongitude, ~.scientificName_empty, ~.coordinates_empty, ~.coordinates_outOfRange, ~.basisOfRecords_notStandard, ~country_suggested, ~countryCode, ~coordinates_transposed, ~.coordinates_country_inconsistent, ~.occurrenceAbsent, ~.unLicensed, ~.GBIFflags, ~.uncer_terms,               ~names_clean, ~.invalidName, ~.rou, ~.val, ~.equ, ~.zer, ~.cap, ~.cen, ~.gbf, ~.inst, ~.sequential, ~.lonFlag, ~.latFlag, ~.gridSummary, ~.uncertaintyThreshold, ~countryMatch, ~.countryOutlier, ~.sea, ~.eventDate_empty, ~.year_outOfRange, ~.duplicates, ~.expertOutlier, ~postal, ~stateMatch, ~stateMatch_certainty, ~.stateOutlier,
              "Megachilidae", "Megachilinae", "Pseudoanthidium", "Pseudoanthidium truncatum",      "truncatum",  "SPECIES",  "HOLOTYPE",               NA,                NA,             "Kigoma",                                                              NA,      NA,       "Ujiji", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/15/31",  15L,     8L, 1931L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "James Ogilvie",                   NA,                             NA,              NA, "AMNH_IZC 00323864",           "AMNH", "AMNH Hymenoptera", "Pachyanthidium truncatum (Smith)",          "8/15/31", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,               FALSE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE, "Pachyanthidium truncatum",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                   NA,                                                 "near Weing Sa",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/25/27",  25L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323581",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/25/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                    FALSE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan", "Lake Waskesiu, at the beginning of the portage to Heart Lakes",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/31/36",  31L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT", "T. D. A. Cockerell & Wilmatte P. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323583",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/31/36",   "MALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                        FALSE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,     "North Carolina",                                                              NA,      NA,     "Raleigh", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "5/29/24",  29L,     5L, 1924L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "C. S. Brimley",                   NA,                             NA,              NA, "AMNH_IZC 00324010",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "5/29/24", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                   FALSE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan",                     "Prince Albert National Park, Lake Ajawaan",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/26/36",  26L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323630",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/26/36", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                              FALSE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                "Nan",                                                              NA,      NA,         "Nan", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/31/27",  31L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323584",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/31/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,              FALSE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA, "MeknÔøΩs-Tafilalet",                                                              NA,      NA,      "Ifrane", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/25/31",  25L,     8L, 1931L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",       "T. D. A. Cockerell & Alice M. Mackie",                   NA,                             NA,              NA, "AMNH_IZC 00323616",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/25/31", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,        FALSE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA, "MeknÔøΩs-Tafilalet",                                                              NA,      NA,      "Ifrane", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/26/30",  26L,     8L, 1930L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                            "Alice M. Mackie",                   NA,                             NA,              NA, "AMNH_IZC 00323619",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/26/30",   "MALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,       FALSE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
              "Megachilidae", "Megachilinae", "Pseudoanthidium", "Pseudoanthidium truncatum",      "truncatum",  "SPECIES",  "HOLOTYPE",               NA,                NA,             "Kigoma",                                                              NA,      NA,       "Ujiji", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/15/31",  15L,     8L, 1931L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "James Ogilvie",                   NA,                             NA,              NA, "AMNH_IZC 00323864",           "AMNH", "AMNH Hymenoptera", "Pachyanthidium truncatum (Smith)",          "8/15/31", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,         FALSE, "Pachyanthidium truncatum",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                   NA,                                                 "near Weing Sa",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/25/27",  25L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323581",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/25/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",         FALSE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan", "Lake Waskesiu, at the beginning of the portage to Heart Lakes",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/31/36",  31L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT", "T. D. A. Cockerell & Wilmatte P. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323583",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/31/36",   "MALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE, FALSE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,     "North Carolina",                                                              NA,      NA,     "Raleigh", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "5/29/24",  29L,     5L, 1924L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "C. S. Brimley",                   NA,                             NA,              NA, "AMNH_IZC 00324010",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "5/29/24", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE, FALSE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan",                     "Prince Albert National Park, Lake Ajawaan",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/26/36",  26L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323630",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/26/36", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE, FALSE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                "Nan",                                                              NA,      NA,         "Nan", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/31/27",  31L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323584",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/31/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE, FALSE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA, "MeknÔøΩs-Tafilalet",                                                              NA,      NA,      "Ifrane", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/25/31",  25L,     8L, 1931L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",       "T. D. A. Cockerell & Alice M. Mackie",                   NA,                             NA,              NA, "AMNH_IZC 00323616",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/25/31", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE, FALSE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA, "MeknÔøΩs-Tafilalet",                                                              NA,      NA,      "Ifrane", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/26/30",  26L,     8L, 1930L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                            "Alice M. Mackie",                   NA,                             NA,              NA, "AMNH_IZC 00323619",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/26/30",   "MALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE, FALSE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
              "Megachilidae", "Megachilinae", "Pseudoanthidium", "Pseudoanthidium truncatum",      "truncatum",  "SPECIES",  "HOLOTYPE",               NA,                NA,             "Kigoma",                                                              NA,      NA,       "Ujiji", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/15/31",  15L,     8L, 1931L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "James Ogilvie",                   NA,                             NA,              NA, "AMNH_IZC 00323864",           "AMNH", "AMNH Hymenoptera", "Pachyanthidium truncatum (Smith)",          "8/15/31", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,               FALSE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE, "Pachyanthidium truncatum",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE, FALSE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                   NA,                                                 "near Weing Sa",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/25/27",  25L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323581",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/25/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                    FALSE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  FALSE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan", "Lake Waskesiu, at the beginning of the portage to Heart Lakes",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/31/36",  31L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT", "T. D. A. Cockerell & Wilmatte P. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323583",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/31/36",   "MALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                        FALSE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,        FALSE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,     "North Carolina",                                                              NA,      NA,     "Raleigh", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "5/29/24",  29L,     5L, 1924L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "C. S. Brimley",                   NA,                             NA,              NA, "AMNH_IZC 00324010",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "5/29/24", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                   FALSE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,     FALSE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan",                     "Prince Albert National Park, Lake Ajawaan",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/26/36",  26L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323630",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/26/36", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                              FALSE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,     FALSE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                "Nan",                                                              NA,      NA,         "Nan", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/31/27",  31L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323584",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/31/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,              FALSE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,         FALSE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA, "MeknÔøΩs-Tafilalet",                                                              NA,      NA,      "Ifrane", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/25/31",  25L,     8L, 1931L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",       "T. D. A. Cockerell & Alice M. Mackie",                   NA,                             NA,              NA, "AMNH_IZC 00323616",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/25/31", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,        FALSE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                  FALSE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA, "MeknÔøΩs-Tafilalet",                                                              NA,      NA,      "Ifrane", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/26/30",  26L,     8L, 1930L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                            "Alice M. Mackie",                   NA,                             NA,              NA, "AMNH_IZC 00323619",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/26/30",   "MALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,       FALSE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,         FALSE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
              "Megachilidae", "Megachilinae", "Pseudoanthidium", "Pseudoanthidium truncatum",      "truncatum",  "SPECIES",  "HOLOTYPE",               NA,                NA,             "Kigoma",                                                              NA,      NA,       "Ujiji", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/15/31",  15L,     8L, 1931L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "James Ogilvie",                   NA,                             NA,              NA, "AMNH_IZC 00323864",           "AMNH", "AMNH Hymenoptera", "Pachyanthidium truncatum (Smith)",          "8/15/31", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,         FALSE, "Pachyanthidium truncatum",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,            FALSE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                   NA,                                                 "near Weing Sa",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/25/27",  25L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323581",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/25/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE, FALSE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan", "Lake Waskesiu, at the beginning of the portage to Heart Lakes",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/31/36",  31L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT", "T. D. A. Cockerell & Wilmatte P. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323583",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/31/36",   "MALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,             FALSE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,     "North Carolina",                                                              NA,      NA,     "Raleigh", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "5/29/24",  29L,     5L, 1924L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "C. S. Brimley",                   NA,                             NA,              NA, "AMNH_IZC 00324010",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "5/29/24", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,             FALSE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan",                     "Prince Albert National Park, Lake Ajawaan",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/26/36",  26L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323630",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/26/36", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,        FALSE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                "Nan",                                                              NA,      NA,         "Nan", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/31/27",  31L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323584",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/31/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,           FALSE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,     "North Carolina",                                                              NA,      NA,     "Raleigh", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "5/29/24",  29L,     5L, 1924L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                              "C. S. Brimley",                   NA,                             NA,              NA, "AMNH_IZC 00324010",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "5/29/24", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,          FALSE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,       "Saskatchewan",                     "Prince Albert National Park, Lake Ajawaan",      NA,            NA, "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE",  "8/26/36",  26L,     8L, 1936L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323630",           "AMNH", "AMNH Hymenoptera",                         "Halictus",          "8/26/36", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE,
                "Halictidae",   "Halictinae",        "Halictus",          "Halictus simplex",        "simplex",    "GENUS",  "HOLOTYPE",               NA,                NA,                "Nan",                                                              NA,      NA,         "Nan", "CC_BY_4_0", "OCCURRENCE_STATUS_INFERRED_FROM_INDIVIDUAL_COUNT;TAXON_MATCH_HIGHERRANK;INSTITUTION_MATCH_FUZZY;COLLECTION_MATCH_NONE", "12/31/27",  31L,    12L, 1927L, "PRESERVED_SPECIMEN",       NA,    NA,         "PRESENT",                         "T. D. A. Cockerell",                   NA,                             NA,              NA, "AMNH_IZC 00323584",           "AMNH", "AMNH Hymenoptera",                         "Halictus",         "12/31/27", "FEMALE",      NA, "American Museum of Natural History",          FALSE,                FALSE,              NA, "Kept duplicate",                       NA,                NA,                 NA,                   TRUE,                TRUE,                     TRUE,                         TRUE,                 NA,           NA,                    TRUE,                               TRUE,               TRUE,         TRUE,        TRUE,          TRUE,                 "Halictus",          TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,   TRUE,         TRUE,      TRUE,      TRUE,          TRUE,                   TRUE,          TRUE,             TRUE,  TRUE,              TRUE,              TRUE,         TRUE,            TRUE,      NA,        TRUE,                  TRUE,           TRUE
              )




# run the function
testOut <- BeeBDC::summaryFun(data = testData, dontFilterThese = NULL, removeFilterColumns = FALSE, filterClean = FALSE)


# test that function added a column
testthat::test_that("summaryFun added column", {
  testthat::expect_equal((ncol(testOut) - ncol(testData)), 1)
})

# test that .summary column contains correct values for test data
correct <- c(FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
             FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
             FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE)
             

testthat::test_that("summaryFun .summary column with correct values", {
  testthat::expect_equal(testOut$.summary, correct)
})
