% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateBeeGUTS.R
\name{validate.beeSurvFit}
\alias{validate.beeSurvFit}
\title{Validate method for \code{beeSurvFit} objects}
\usage{
\method{validate}{beeSurvFit}(object, dataValidate, ...)
}
\arguments{
\item{object}{An object of class \code{beeSurvFit}}

\item{dataValidate}{Data to validate in the format of the experimental data used for fit (dataGUTS)}

\item{...}{Additional arguments to be parsed to the  \code{predict.survFit} method from \code{odeGUTS} (e.g.
\code{mcmc_size = 1000} is to be used to reduce the number of mcmc samples in order to speed up
the computation. \code{mcmc_size} is the number of selected iterations for one chain. Default
is 1000. If all MCMC is wanted, set argument to \code{NULL}.,
\code{hb_value  = FALSE} the background mortality \code{hb} is taken into account from the posterior.
If \code{FALSE}, parameter \code{hb} is set to a fixed value. The default is \code{FALSE}.
\code{hb_valueFORCED  = 0} hb_valueFORCED If \code{hb_value} is \code{FALSE}, it fix \code{hb}. The default is \code{0}}
}
\value{
A \code{beeSurvValidation} object with the results of the validation
}
\description{
This is the generic \code{validate} S3 method for the \code{beeSurvFit}
class. It predict the survival over time for the concentration profiles entered by the user.
}
\examples{
\donttest{
data(betacyfluthrinChronic)
data(fitBetacyfluthrin_Chronic)
validation <- validate(fitBetacyfluthrin_Chronic, betacyfluthrinChronic)
}
}
