% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_CJ.R
\name{evidence_CJ}
\alias{evidence_CJ}
\title{Marginal likelihood estimation}
\usage{
evidence_CJ(ergm.formula, prior.mean, prior.sigma, nits, burnin, thin = 1,
  num.samples = 5000, tunePL = 2, seed = NA, calibr.info = NULL)
}
\arguments{
\item{ergm.formula}{formula; an \code{R} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link{network}} object
and <model terms> are \code{\link{ergm-terms}}.}

\item{prior.mean}{vector; Prior means.}

\item{prior.sigma}{matrix; Prior covariance matrix.}

\item{nits}{count; Number of MCMC iterations after burn-in for the adjusted pseudo-posterior estimation.}

\item{burnin}{count; Number of burn-in iterations at the beginning of an MCMC run for the adjusted pseudo-posterior estimation.}

\item{thin}{count; Thinning interval used in the simulation for the adjusted pseudo-posterior estimation. The number of MCMC iterations must be divisible by this value.}

\item{num.samples}{integer; number of samples used in the marginal likelihood estimate. Must be <=(nits-burnin).}

\item{tunePL}{count; Tuning parameter for the Metropolis sampling for the pseudo-posterior estimation.}

\item{seed}{The seed for the random number generator. See \code{\link[MCMCpack]{MCMCmetrop1R}}.}

\item{calibr.info}{list; Transformation parameters for
adjusting the pseudolikelihood function. See \code{\link[Bergm]{adjustPL}}.}
}
\description{
Function to estimate the marginal likelihood with Chib and Jeliazkov's method, 
based on the adjusted pseudolikelihood function.
}
\examples{
\dontrun{
# Load the florentine marriage network:
data(florentine)

flo.formula <- flomarriage ~ edges + kstar(2)

info.adjustPL <- adjustPL(ergm.formula = flo.formula,
                          aux.iters    = 100, 
                          noisy.nsim   = 50,   
                          noisy.thin   = 50,   
                          ladder       = 30,   
                          estimate     = "MLE",
                          control      = control.ergm(MCMC.samplesize=2000))

# Add the output into a list:
calibration.list <- list(Theta_MLE= info.adjustPL$Theta_MLE,
                         Theta_PL = info.adjustPL$Theta_PL, 
                         W        = info.adjustPL$W, 
                         C        = info.adjustPL$C)
                         
# Specify location and shape of prior distribution: 
mean.priors  <- rep(0,2)
sigma        <- 5
sigma.priors <- diag(sigma,2)          
                                                
# MCMC sampling and evidence estimation:
Chib.est.evidence <- evidence_CJ(ergm.formula= flo.formula,
                                 prior.mean   = mean.priors,   
                                 prior.sigma  = sigma.priors,
                                 nits         = 30000,
                                 burnin       = 5000,
                                 thin         = 1,
                                 num.samples  = 25000,
                                 tunePL       = 2,
                                 calibr.info  = calibration.list,
                                 seed         = 1)                         
                                   
# MCMC diagnostics and posterior summaries:
bergm.output(Chib.est.evidence)
  
# Log-marginal likelihood estimate:             
flo.model.logevidence <- Chib.est.evidence$log.evidence
}

}
\references{
Bouranis, L., Friel, N., and Maire, F. (2017). Bayesian model selection for exponential random graph models via
adjusted pseudolikelihoods. \url{https://arxiv.org/abs/1706.06344}
}
