% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_samplesize.R
\name{plot_samplesize}
\alias{plot_samplesize}
\title{Plots by mu1}
\usage{
plot_samplesize(SS.matrix,link.type)
}
\arguments{
\item{SS.matrix}{the matrix obtained by the function samplesize.(the formula was described as the output formula in the function samplesize)}

\item{link.type}{the type of link used in the beta regression(or Wilcoxon Rank Sum Test). You can choose one or more of the following: "logit", "probit", "cloglog", "cauchit", "log", "loglog", "wilcoxon", "all"}
}
\description{
Generate the comparison plots using GLM method and Wilcoxon Rank Sum Test with different mu1.
}
\details{
plot_samplesize() returns a series of plots equal to the number of mu1 used in the procedure.
Y-axis denotes minimum sample size and X-axis denotes minimum power.
}
\examples{
## use a greater number of trials, e.g. 1000, to get accurate result
## generate sample size matrix
SSmat <- samplesize(mu0=0.56, sd0=0.255, mu1.start = 0.75, 
power.start =  0.8, power.end = 0.9, power.by = 0.1, 
trials = 10, link.type = c("log","wilcoxon"))
## plot with parametric and nonparametric methods
plot_samplesize(SSmat, c("log","wilcoxon"))
}
