% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Omega_Indices.R
\name{Omega_S}
\alias{Omega_S}
\title{Omega_S}
\usage{
Omega_S(Lambda, Theta)
}
\arguments{
\item{Lambda}{is a matrix of factor loadings}

\item{Theta}{is a vector of indicator error variances}
}
\value{
A \code{numeric}, the omega reliability estimate for all factors.
}
\description{
Computes an omega reliability estimate for all factors as described in Rodriguez, Reise, and
Haviland (2016).
}
\details{
\code{Omega_S} is called by \code{\link{bifactorIndices}} and \code{\link{bifactorIndicesMplus}},
which are the only functions in this package intended for casual users
}
\examples{
Lambda <- matrix(c(.82, .10,   0,   0,
                   .77, .35,   0,   0,
                   .79, .32,   0,   0,
                   .66, .39,   0,   0,
                   .51,   0, .71,   0,
                   .56,   0, .43,   0,
                   .68,   0, .13,   0,
                   .60,   0, .50,   0,
                   .83,   0,   0, .47,
                   .60,   0,   0, .27,
                   .78,   0,   0, .28,
                   .55,   0,   0, .75),
                   ncol = 4, byrow = TRUE)
colnames(Lambda) <- c("General", "PS", "HA", "SA")
Theta <- rep(1, nrow(Lambda)) - rowSums(Lambda^2)
Omega_S(Lambda, Theta)

}
\references{
Rodriguez, A., Reise, S. P., & Haviland, M. G. (2016). Evaluating bifactor models:
calculating and interpreting statistical indices. \emph{Psychological Methods, 21}(2),
137 \doi{10.1037/met0000045}.
}
\seealso{
\code{\link{Omega_H}}, \code{\link{bifactorIndices}}, \code{\link{bifactorIndicesMplus}}
}
