% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other_Indices.R
\name{FD}
\alias{FD}
\title{Factor Determinacy}
\usage{
FD(Lambda, Phi)
}
\arguments{
\item{Lambda}{is a matrix of standardized factor loadings}

\item{Phi}{is the matrix of factor intercorrelations. For bifactor models
\code{Phi} is diagonal with ones on the diagonal.}
}
\value{
a vector of factor determinacies.
}
\description{
\code{FD} computes factor determinacies for all factors provided
standardized factor loadings and an interfactor correlation matrix.
}
\details{
\code{FD} is called by \code{\link{bifactorIndices}} and the various convenience functions
for exploratory models and/or Mplus output,
which are the only functions in this package intended for casual users.
}
\examples{
Lambda <- matrix(c(.82, .10,   0,   0,
                   .77, .35,   0,   0,
                   .79, .32,   0,   0,
                   .66, .39,   0,   0,
                   .51,   0, .71,   0,
                   .56,   0, .43,   0,
                   .68,   0, .13,   0,
                   .60,   0, .50,   0,
                   .83,   0,   0, .47,
                   .60,   0,   0, .27,
                   .78,   0,   0, .28,
                   .55,   0,   0, .75),
                   ncol = 4, byrow = TRUE)
Phi <- matrix(c(1, 0, 0, 0,
                0, 1, 0, 0,
                0, 0, 1, 0,
                0, 0, 0, 1), ncol = 4)
colnames(Lambda) <- c("General", "SF1", "SF2", "SF3")
FD(Lambda, Phi)

}
\seealso{
\code{\link{bifactorIndices}}
}
