% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdtCrossprod_Weighted}
\alias{bdtCrossprod_Weighted}
\title{Block matrix multiplication with Delayed Array Object}
\usage{
bdtCrossprod_Weighted(A, W, block_size = NULL, paral = NULL, threads = NULL)
}
\arguments{
\item{A}{a double matrix.}

\item{W}{a Weighted matrix}

\item{block_size}{(optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)}

\item{paral, }{(optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation}

\item{threads}{(optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available}
}
\value{
Matrix with A%*%W%*%t(A) product
}
\description{
This function performs a Crossproduct with weigths matrix A%*%W%*%t(A) multiplication with numeric matrix or Delayed Arrays
}
\examples{

library(DelayedArray)

# with numeric matrix
m <- 500
k <- 1500
n <- 400
A <- matrix(rnorm(n*k), nrow=n, ncol=k)
B <- matrix(rnorm(n*k), nrow=k, ncol=n)


# with Delaeyd Array
AD <- DelayedArray(A)
BD <- DelayedArray(B)

# Serial execution
Serie<- bdtCrossprod_Weighted(A, B, paral = FALSE)

# Parallel execution with 2 threads and blocks 256x256
Par_2cor <- bdtCrossprod_Weighted(A, B, paral = TRUE, block_size = 256, threads = 2)
}
