% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/476-extractDrugEstate.R
\name{extrDrugEstate}
\alias{extrDrugEstate}
\title{Calculate the E-State Molecular Fingerprints (in Compact Format)}
\usage{
extrDrugEstate(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
A list, each component represents one of the molecules, each element 
in the component represents the index of which element in the fingerprint is 1.
Each component's name is the length of the fingerprints.
}
\description{
Calculate the E-State Molecular Fingerprints (in Compact Format)
}
\details{
79 bit fingerprints corresponding to the E-State atom types 
described by Hall and Kier.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugEstate(mol)
head(fp)

}
\seealso{
\link{extrDrugEstateComplete}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugEstate}
