% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/512-extractProtQSO.R
\name{extrProtQSO}
\alias{extrProtQSO}
\title{Quasi-Sequence-Order (QSO) Descriptor}
\usage{
extrProtQSO(x, nlag = 30, w = 0.1)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}

\item{nlag}{The maximum lag, defualt is 30.}

\item{w}{The weighting factor, default is 0.1.}
}
\value{
A length \code{20 + 20 + (2 * nlag)} named vector
}
\description{
Quasi-Sequence-Order (QSO) Descriptor
}
\details{
This function calculates the Quasi-Sequence-Order (QSO) descriptor
(Dim: \code{20 + 20 + (2 * nlag)}, default is 100).
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'BioMedR'))[[1]]
extrProtQSO(x)

}
\references{
Kuo-Chen Chou. Prediction of Protein Subcellar Locations by 
Incorporating Quasi-Sequence-Order Effect.
\emph{Biochemical and Biophysical Research Communications},
2000, 278, 477-483.

Kuo-Chen Chou and Yu-Dong Cai. Prediction of Protein Sucellular Locations by
GO-FunD-PseAA Predictor. 
\emph{Biochemical and Biophysical Research Communications},
2004, 320, 1236-1239.

Gisbert Schneider and Paul Wrede. The Rational Design of 
Amino Acid Sequences by Artifical Neural Networks and Simulated 
Molecular Evolution: Do Novo Design of an Idealized Leader Cleavge Site.
\emph{Biophys Journal}, 1994, 66, 335-344.
}
\seealso{
See \code{\link{extrProtSOCN}} 
for sequence-order-coupling numbers.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{Order}
\keyword{QSO}
\keyword{Quasi}
\keyword{Quasi-Sequence-Order}
\keyword{Sequence}
\keyword{extrProtQSO}
\keyword{extract}
