% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/503-extractProtTC.R
\name{extrProtTC}
\alias{extrProtTC}
\title{Tripeptide Composition Descriptor}
\usage{
extrProtTC(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 8000 named vector
}
\description{
Tripeptide Composition Descriptor
}
\details{
This function calculates the Tripeptide Composition descriptor (Dim: 8000).
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'BioMedR'))[[1]]
extrProtTC(x)

}
\references{
M. Bhasin, G. P. S. Raghava.
Classification of Nuclear Receptors Based on 
Amino Acid Composition and Dipeptide Composition. 
\emph{Journal of Biological Chemistry}, 2004, 279, 23262.
}
\seealso{
See  \code{\link{extrProtDC}} for  dipeptide composition descriptors.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{Composition}
\keyword{TC}
\keyword{Tripeptide}
\keyword{extrProtTC}
\keyword{extract}
