% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/801-getCPI.R
\name{getCPI}
\alias{getCPI}
\alias{getPPI}
\alias{getDDI}
\alias{getDPI}
\alias{getCCI}
\alias{getCDI}
\title{Generating Interaction Descriptors}
\usage{
getCPI(drugmat, protmat, type = c("combine", "tensorprod"))

getPPI(protmat1, protmat2, type = c("combine", "tensorprod",
  "entrywise"))

getDDI(DNAmat1, DNAmat2, type = c("combine", "tensorprod", "entrywise"))

getDPI(DNAmat, protmat, type = c("combine", "tensorprod"))

getCCI(drugmat1, drugmat2, type = c("combine", "tensorprod",
  "entrywise"))

getCDI(drugmat, DNAmat, type = c("combine", "tensorprod"))
}
\arguments{
\item{drugmat}{The compound descriptor matrix.}

\item{protmat}{The protein descriptor matrix.}

\item{type}{The interaction type, one or more of
\code{"combine"}, \code{"tensorprod"}, and \code{"entrywise"}.}

\item{protmat1}{The first protein descriptor matrix, 
must have the same ncol with \code{protmat2}.}

\item{protmat2}{The second protein descriptor matrix, 
must have the same ncol with \code{protmat1}.}

\item{DNAmat1}{The first DNA descriptor matrix, 
must have the same ncol with \code{DNAmat2}.}

\item{DNAmat2}{The second DNA descriptor matrix, 
must have the same ncol with \code{DNAmat1}.}

\item{DNAmat}{The DNA descriptor matrix.}

\item{drugmat1}{The first compound descriptor matrix, 
must have the same ncol with \code{drugmat2}.}

\item{drugmat2}{The second compound descriptor matrix, 
must have the same ncol with \code{drugmat1}.}
}
\value{
A matrix containing the interaction descriptors
}
\description{
Generating Interaction Descriptors
}
\details{
This function calculates the interaction descriptors
by three types of interaction:
\itemize{
\item \code{combine} - combine the two descriptor matrix, 
result has \code{(p1 + p2)} columns
\item \code{tensorprod} - calculate column-by-column 
(pseudo)-tensor product type interactions, result has 
\code{(p1 * p2)} columns
\item \code{entrywise} - calculate entrywise product and 
entrywise sum of the two matrices, then combine them, 
result has \code{(p + p)} columns
}
}
\examples{
x = matrix(1:10, ncol = 2)
y = matrix(1:15, ncol = 3)
# getCPI 
getCPI(x, y, 'combine')
# getCDI
getCDI(x, y, 'tensorprod')
# getDPI
getDPI(x, y, type = c('combine', 'tensorprod'))
getDPI(x, y, type = c('tensorprod', 'combine'))

x = matrix(1:10, ncol = 2)
y = matrix(5:14, ncol = 2)

# getPPI 
getPPI(x, y, type = 'combine')
getPPI(x, y, type = 'tensorprod')
# getDDI
getDDI(x, y, type = 'entrywise')
getDDI(x, y, type = c('combine', 'tensorprod'))
# getCCI
getCCI(x, y, type = c('combine', 'entrywise'))
getCCI(x, y, type = c('entrywise', 'tensorprod'))
getCCI(x, y, type = c('combine', 'entrywise', 'tensorprod'))
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{getCCI}
\keyword{getCDI}
\keyword{getCPI}
\keyword{getDDI}
\keyword{getDPI}
\keyword{getPPI}
\keyword{interaction}
