% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/705-searchDrug.R
\name{searchDrug}
\alias{searchDrug}
\title{Parallelized Drug Molecule Similarity Search by 
Molecular Fingerprints Similarity or Maximum Common Substructure Search}
\usage{
searchDrug(mol, moldb, method = c("fp", "mcs"),
  fptype = c("standard", "extended", "graph", "hybrid", "maccs",
  "estate", "pubchem", "kr", "shortestpath"), fpsim = c("tanimoto",
  "euclidean", "cosine", "dice", "hamming"), mcssim = c("tanimoto",
  "overlap"), ...)
}
\arguments{
\item{mol}{The query molecule. The location of a \code{sdf} file 
containing one molecule.}

\item{moldb}{The molecule database. The location of a \code{sdf} file 
containing all the molecules to be searched with.}

\item{method}{\code{'fp'} or \code{'mcs'}. Search by molecular fingerprints
or by maximum common substructure searching.}

\item{fptype}{The fingerprint type, only available when \code{method = 'fp'}.
BioMedR supports 13 types of fingerprints, including 
\code{'standard'}, \code{'extended'}, \code{'graph'},
\code{'hybrid'}, \code{'maccs'}, \code{'estate'}, 
\code{'pubchem'}, \code{'kr'}, \code{'shortestpath'}.}

\item{fpsim}{Similarity measure type for fingerprint, 
only available when \code{method = 'fp'}.
Including \code{'tanimoto'}, \code{'euclidean'}, 
\code{'cosine'}, \code{'dice'} and \code{'hamming'}. 
See \code{calcDrugFPSim} for details.}

\item{mcssim}{Similarity measure type for maximum common substructure search, 
only available when \code{method = 'mcs'}. 
Including \code{'tanimoto'} and \code{'overlap'}.}

\item{...}{Other possible parameter for maximum common substructure search.}
}
\value{
Named numerical vector.
With the decreasing similarity value of the molecules in the database.
}
\description{
Parallelized Drug Molecule Similarity Search by 
Molecular Fingerprints Similarity or Maximum Common Substructure Search
}
\details{
This function does compound similarity search derived by 
various molecular fingerprints with various similarity measures or 
derived by maximum common substructure search.
This function runs for a query compound against a set of molecules.
}
\examples{
\donttest{
mol = system.file('compseq/example.sdf', package = 'BioMedR')
# DrugBank ID DB00530: Erlotinib
moldb = system.file('compseq/bcl.sdf', package = 'BioMedR')
# Database composed by searching 'tyrphostin' in PubChem and filtered by Lipinski's Rule of Five
searchDrug(mol, moldb, method = 'fp', fptype = 'maccs', fpsim = 'hamming')}

}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{Drug}
\keyword{MCS}
\keyword{Molecule}
\keyword{Search}
\keyword{Similarity}
\keyword{searchDrug}
