% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDjointPMF.R
\name{BDjointPMF}
\alias{BDjointPMF}
\alias{dbdbivgeo1}
\alias{dbdbivgeo2}
\title{Joint Probability Mass Function for the Basu-Dhar Bivariate Geometric Distribution}
\source{
\code{\link[BivGeo]{dbdbivgeo1}} and \code{\link[BivGeo]{dbdbivgeo2}} are calculated directly from the definitions.
}
\usage{
dbdbivgeo1(x, y = NULL, theta, log = FALSE)
dbdbivgeo2(x, y = NULL, theta, log = FALSE)
}
\arguments{
\item{x}{matrix or vector containing the data. If x is a matrix then it is considered as x the first column and y the second column (y argument need be setted to NULL). Additional columns and y are ignored.}

\item{y}{vector containing the data of y. It is used only if x is also a vector. Vectors x and y should be of equal length.}

\item{theta}{vector (of length 3) containing values of the parameters \eqn{\theta_1, \theta_2} and \eqn{\theta_{12}} of the Basu-Dhar bivariate Geometric distribution. The parameters are restricted to \eqn{0 < \theta_i < 1, i = 1,2} and \eqn{0 < \theta_{12} \le 1}.}

\item{log}{logical argument for calculating the log probability or the probability function. The default value is FALSE.}
}
\value{
\code{\link[BivGeo]{dbdbivgeo1}} gives the values of the probability mass function using the first form of the joint pmf.

\code{\link[BivGeo]{dbdbivgeo2}} gives the values of the probability mass function using the second form of the joint pmf.

Invalid arguments will return an error message.
}
\description{
This function computes the joint probability mass function of the Basu-Dhar bivariate geometric distribution for arbitrary parameter values.
}
\details{
The joint probability mass function for a random vector (\eqn{X}, \eqn{Y}) following a Basu-Dhar Bivariate Geometric Distribution could be written in two forms. The first form is described by:
\deqn{P(X = x, Y = y) = \theta_{1}^{x - 1} \theta_{2}^{y - 1} \theta_{12}^{z_1} - \theta_{1}^{x} \theta_{2}^{y - 1} \theta_{12}^{z_2} - \theta_{1}^{x - 1} \theta_{2}^{y} \theta_{2}^{z_3} + \theta_{1}^{x} \theta_{2}^{y} \theta_{12}^{z_4}}
where \eqn{x,y > 0} are positive integers and \eqn{z_1 = \max(x - 1, y - 1),z_2 = \max(x, y - 1), z_3 = \max(x - 1, y), z_4 = \max(x, y)}. The second form is given by the conditions:

If X < Y, then
\deqn{P(X = x, Y = y) = \theta_1^{x - 1} (\theta_2 \theta_{12})^{y - 1}(1 - \theta_{2} \theta_{12}) (1 - \theta_1)}
If X = Y, then
\deqn{P(X = x, Y = y) = (\theta_1 \theta_2 \theta_{12})^{x - 1}(1 - \theta_1 \theta_{12} - \theta_2 \theta_{12} + \theta_1 \theta_2 \theta_{12}) }
If X > Y, then
\deqn{P(X = x, Y = y) = \theta_2^{y - 1} (\theta_1 \theta_{12})^{x - 1}(1 - \theta_{1} \theta_{12}) (1 - \theta_2)}
}
\examples{

# If x and y are integer numbers:

dbdbivgeo1(1, 2, c(0.2, 0.4, 0.7), log = FALSE)
# [1] 0.16128
dbdbivgeo2(1, 2, c(0.2, 0.4, 0.7), log = FALSE)
# [1] 0.16128

# If x is a matrix:

matr 	<- 	 matrix(c(1,2,3,5), ncol = 2)

dbdbivgeo1(matr, y = NULL, c(0.2,0.4,0.7))
# [1] 0.0451584000 0.0007080837
dbdbivgeo2(matr, y = NULL, c(0.2,0.4,0.7))
# [1] 0.0451584000 0.0007080837

# If log = TRUE:

dbdbivgeo1(1, 2, c(0.2, 0.4, 0.7), log = TRUE)
# [1] -1.824613
dbdbivgeo2(1, 2, c(0.2, 0.4, 0.7), log = TRUE)
# [1] -1.824613

}
\references{
Basu, A. P., & Dhar, S. K. (1995). Bivariate geometric distribution. \emph{Journal of Applied Statistical Science}, \bold{2}, 1, 33-44.

Achcar, J. A., Davarzani, N., & Souza, R. M. (2016). Basu–Dhar bivariate geometric distribution in the presence of covariates and censored data: a Bayesian approach. \emph{Journal of Applied Statistics}, \bold{43}, 9, 1636-1648.

de Oliveira, R. P., & Achcar, J. A. (2018). Basu-Dhar's bivariate geometric distribution in presence of censored data and covariates: some computational aspects. \emph{Electronic Journal of Applied Statistical Analysis}, \bold{11}, 1, 108-136.
}
\seealso{
\code{\link[stats]{Geometric}} for the univariate geometric distribution.
}
\author{
Ricardo P. Oliveira \email{rpuziol.oliveira@gmail.com}

Jorge Alberto Achcar \email{achcar@fmrp.usp.br}
}
