% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_ChooseCenter.R
\name{BP_ChooseCenter}
\alias{BP_ChooseCenter}
\title{Let the user to choose the center of the bone}
\usage{
BP_ChooseCenter(bone, analysis = 1)
}
\arguments{
\item{bone}{The bone image to be used}

\item{analysis}{The name or rank of analysis}
}
\value{
The orignal bone object with a new attribute for center
}
\description{
Let the user to choose the center of the bone.
}
\details{
BP_ChooseCenter lets the use to choose the center of the bone
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone)
 bone <- BP_DetectForeground(bone=bone)
 bone <- BP_ChooseCenter(bone=bone)
 # For partial section, only BP_ChooseCenter() must be used
 path_Dicynodon <- system.file("extdata", "Dicynodon_tibia_11.11.1.T_b_b-1.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Dicynodon)
 bone <- BP_DetectBackground(bone=bone)
 bone <- BP_DetectForeground(bone=bone)
 bone <- BP_ChooseCenter(bone=bone)
 bone <- BP_EstimateCompactness(bone, center="user", partial=TRUE)
 bone <- BP_FitMLCompactness(bone, analysis=1)
 plot(bone, type="observations+model")
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
