\name{attStats}
\alias{attStats}
\title{Extract attribute statistics}
\usage{
  attStats(x)
}
\arguments{
  \item{x}{an object of a class Boruta, from which
  attribute stats should be extracted.}
}
\value{
  A data frame containing, for each attribute that was
  originally in information system, mean, median, maximal
  and minimal importance, number of hits normalised to
  number of importance source runs performed and the
  decision copied from \code{finalDecision}.
}
\description{
  attStats shows a summary of a Boruta run in an
  attribute-centred way. It produces a data frame
  containing some importance stats as well as the number of
  hits that attribute scored and the decision it was given.
}
\note{
  When using a Boruta object generated by a
  \code{\link{TentativeRoughFix}}, the resulting data frame
  will consist a rough fixed decision.
}
\examples{
\dontrun{
library(mlbench); data(Sonar);
#Takes some time, so be patient
Boruta(Class~.,data=Sonar,doTrace=2)->Bor.son;
print(Bor.son);
stats<-attStats(Bor.son);
print(stats);
plot(normHits~meanZ,col=stats$decision,data=stats);
}
}
\author{
  Miron B. Kursa
}

