% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLMTable.R
\name{ROC}
\alias{ROC}
\alias{ROC.numeric}
\alias{ROC.BranchGLM}
\title{ROC Curve}
\usage{
ROC(object, ...)

\method{ROC}{numeric}(object, y, ...)

\method{ROC}{BranchGLM}(object, ...)
}
\arguments{
\item{object}{a \code{BranchGLM} object or a numeric vector.}

\item{...}{further arguments passed to other methods.}

\item{y}{observed values, can be a numeric vector of 0s and 1s, a two-level
factor vector, or a logical vector.}
}
\value{
A \code{BranchGLMROC} object which can be plotted with \code{plot()}. The AUC can also
be calculated using \code{AUC()}.
}
\description{
Creates an ROC curve.
}
\examples{
Data <- ToothGrowth
Fit <- BranchGLM(supp ~ ., data = Data, family = "binomial", link = "logit")
MyROC <- ROC(Fit)
plot(MyROC)
}
