% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brundle.R
\name{jg.plotDeSeqCombined}
\alias{jg.plotDeSeqCombined}
\title{jg.plotDeSeqCombined}
\usage{
jg.plotDeSeqCombined(jg.controlResultsDeseq, jg.experimentResultsDeseq,
  title.main, padjX, flip = FALSE)
}
\arguments{
\item{jg.controlResultsDeseq}{is the result Dataframe from DESeq2 for the control conditions}

\item{jg.experimentResultsDeseq}{is the result Dataframe from DESeq2 for the experimental conditions}

\item{title.main}{is the plot title}

\item{padjX}{is the minimum FDR to highlight as significant}

\item{flip}{when set to TRUE flips the data}
}
\description{
Overlays the plots from the output from DESeq2 for the Brundle pipeline
}
\examples{
data(jg.controlResultsDeseq,package="Brundle")
data(jg.experimentResultsDeseq,package="Brundle")

jg.plotDeSeqCombined(as.data.frame(jg.controlResultsDeseq),
                    as.data.frame(jg.experimentResultsDeseq),
                    title.main="ER and CTCF Binding Folding changes on ER treatment",
                    p=0.01,flip=TRUE)

}
\keyword{DESeq2}
\keyword{data}
\keyword{plot}
