% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuyseTest.options.R
\name{BuyseTest.options}
\alias{BuyseTest.options}
\title{Global options for BuyseTest package}
\usage{
BuyseTest.options(..., reinitialise = FALSE)
}
\arguments{
\item{...}{options to be selected or updated}

\item{reinitialise}{should all the global parameters be set to their default value}
}
\description{
Update or select global options for the BuyseTest package.
}
\examples{
library(data.table)

## see all global parameters
BuyseTest.options()

## see some of the global parameters
BuyseTest.options("n.resampling", "trace")

## update some of the global parameters
BuyseTest.options(n.resampling = 10, trace = 1)
BuyseTest.options("n.resampling", "trace")

## reinitialise all global parameters
BuyseTest.options(reinitialise = TRUE)
}
