% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_equivalence.R
\name{emp_eq}
\alias{emp_eq}
\title{Check empirical equivalences between predictors}
\usage{
emp_eq(data, X)
}
\arguments{
\item{data}{Original full data set}

\item{X}{The names of the predictors in the data set}
}
\value{
\item{cp}{Heatmap of correlations between all predictors} 
\item{Graph_pcor}{Partial correlation network between all predictors} 
\item{Graph_pcor_bon}{Partial correlation network between all predictors, with bonferroni correction} 
\item{corMat}{Matrix with correlations between all variables}
}
\description{
Function to check for empirical equivalence relations between predictors in a data set by visualizing (partial) correaltions
}
\examples{
require(MASS)
emp_eq(data = Pima.tr, X = c("npreg", "glu", "bp", "skin", "bmi", "ped", "age"))
}
