/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.plots.ConditionalProbability;
import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class ScatterPlot
extends DataPlotDialog {
    private JCheckBox confIntCheck;
    private JLabel confLabel;
    private JSpinner confLevelSpinner;
    private JCheckBox loessLineCheck;
    private JPanel plotLabelsPane;
    private JPanel plotOptionsPane;
    private JPanel plotPane;
    private JTextField plotTitle;
    private JLabel plotTitleLabel;
    private JCheckBox predIntCheck;
    private JCheckBox regLineCheck;
    private JPanel varPanel;
    private JTextField xAxis;
    private JLabel xAxisLabel;
    private JComboBox xComboBox;
    private JLabel xLabel;
    private JTextField yAxis;
    private JLabel yAxisLabel;
    private JComboBox yComboBox;
    private JLabel yLabel;

    protected void initCustom() {
        this.initComponents();
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScatterPlot.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.getDatasetPane().refreshDatasetComboBox();
        this.getPlotPane().add((Component)this.plotPane, "Center");
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshSubmitButtonValidity();
    }

    public void refreshVariableListValidity() {
        this.xComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.xComboBox.getItemCount() > 0);
        this.yComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.yComboBox.getItemCount() > 0);
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
            this.xComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.yComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            if (this.xComboBox.getItemCount() > 0) {
                this.xComboBox.setSelectedIndex(0);
            }
            if (this.yComboBox.getItemCount() > 0) {
                this.yComboBox.setSelectedIndex(0);
            }
        } else {
            this.xComboBox.removeAllItems();
            this.yComboBox.removeAllItems();
        }
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.xComboBox.getItemCount() > 0 && this.yComboBox.getItemCount() > 0);
    }

    public void refreshConfPredInt() {
        this.confIntCheck.setEnabled(this.regLineCheck.isSelected() || this.loessLineCheck.isSelected());
        this.predIntCheck.setEnabled(this.regLineCheck.isSelected() || this.loessLineCheck.isSelected());
        if (!this.regLineCheck.isSelected() && !this.loessLineCheck.isSelected()) {
            this.confIntCheck.setSelected(false);
            this.predIntCheck.setSelected(false);
        }
        this.confLabel.setEnabled(this.regLineCheck.isSelected() || this.loessLineCheck.isSelected());
        this.confLevelSpinner.setEnabled(this.regLineCheck.isSelected() || this.loessLineCheck.isSelected());
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.varPanel = new JPanel();
        this.xLabel = new JLabel();
        this.xComboBox = new JComboBox();
        this.yLabel = new JLabel();
        this.yComboBox = new JComboBox();
        this.plotOptionsPane = new JPanel();
        this.regLineCheck = new JCheckBox();
        this.loessLineCheck = new JCheckBox();
        this.predIntCheck = new JCheckBox();
        this.confLabel = new JLabel();
        this.confLevelSpinner = new JSpinner();
        this.confIntCheck = new JCheckBox();
        this.plotLabelsPane = new JPanel();
        this.plotTitleLabel = new JLabel();
        this.plotTitle = new JTextField();
        this.xAxisLabel = new JLabel();
        this.xAxis = new JTextField();
        this.yAxisLabel = new JLabel();
        this.yAxis = new JTextField();
        this.varPanel.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.xLabel.setText("X");
        this.yLabel.setText("Y");
        GroupLayout varPanelLayout = new GroupLayout((Container)this.varPanel);
        this.varPanel.setLayout((LayoutManager)varPanelLayout);
        varPanelLayout.setHorizontalGroup((GroupLayout.Group)varPanelLayout.createParallelGroup(1).add((GroupLayout.Group)varPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPanelLayout.createParallelGroup(1).add((GroupLayout.Group)varPanelLayout.createSequentialGroup().add((Component)this.xLabel).addPreferredGap(0).add((Component)this.xComboBox, 0, 166, Short.MAX_VALUE)).add((GroupLayout.Group)varPanelLayout.createSequentialGroup().add((Component)this.yLabel).addPreferredGap(0).add((Component)this.yComboBox, 0, 166, Short.MAX_VALUE))).addContainerGap()));
        varPanelLayout.setVerticalGroup((GroupLayout.Group)varPanelLayout.createParallelGroup(1).add((GroupLayout.Group)varPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPanelLayout.createParallelGroup(3).add((Component)this.xLabel).add((Component)this.xComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)varPanelLayout.createParallelGroup(3).add((Component)this.yLabel).add((Component)this.yComboBox, -2, -1, -2)).addContainerGap(39, Short.MAX_VALUE)));
        this.plotOptionsPane.setBorder(BorderFactory.createTitledBorder("Plot Options"));
        this.regLineCheck.setText("Linear Regression Line");
        this.regLineCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScatterPlot.this.regLineCheckActionPerformed(evt);
            }
        });
        this.loessLineCheck.setText("Loess Smooth");
        this.loessLineCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScatterPlot.this.loessLineCheckActionPerformed(evt);
            }
        });
        this.predIntCheck.setText("Add Prediction Intervals");
        this.predIntCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.predIntCheck.setEnabled(false);
        this.predIntCheck.setMargin(new Insets(0, 0, 0, 0));
        this.confLabel.setText("Confidence / Prediction Level");
        this.confLabel.setEnabled(false);
        this.confLevelSpinner.setModel(new SpinnerNumberModel(0.95, 0.5, 0.99, 0.01));
        this.confLevelSpinner.setEnabled(false);
        this.confIntCheck.setText("Add Confidence Intervals");
        this.confIntCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.confIntCheck.setEnabled(false);
        GroupLayout plotOptionsPaneLayout = new GroupLayout((Container)this.plotOptionsPane);
        this.plotOptionsPane.setLayout((LayoutManager)plotOptionsPaneLayout);
        plotOptionsPaneLayout.setHorizontalGroup((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add(2, (GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((Component)this.regLineCheck).add((Component)this.loessLineCheck)).add(30, 30, 30).add((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().add((Component)this.confIntCheck).addContainerGap()).add((GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().add((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().add(25, 25, 25).add((Component)this.confLabel).addPreferredGap(1).add((Component)this.confLevelSpinner, -2, -1, -2)).add((Component)this.predIntCheck)).add(77, 77, 77)))));
        plotOptionsPaneLayout.setVerticalGroup((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().add((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(3).add((Component)this.regLineCheck).add((Component)this.confIntCheck)).addPreferredGap(1).add((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(3).add((Component)this.loessLineCheck).add((Component)this.predIntCheck, -2, 15, -2)).addPreferredGap(0).add((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(3).add((Component)this.confLabel, -2, 17, -2).add((Component)this.confLevelSpinner, -2, -1, -2)).addContainerGap()));
        this.plotLabelsPane.setBorder(BorderFactory.createTitledBorder("Plot Labels"));
        this.plotTitleLabel.setHorizontalAlignment(4);
        this.plotTitleLabel.setLabelFor(this.plotTitle);
        this.plotTitleLabel.setText("Plot Title");
        this.plotTitle.setColumns(12);
        this.plotTitle.setText("Scatterplot");
        this.xAxisLabel.setHorizontalAlignment(4);
        this.xAxisLabel.setLabelFor(this.xAxis);
        this.xAxisLabel.setText("X-Axis");
        this.xAxis.setColumns(12);
        this.xAxis.setText("X");
        this.yAxisLabel.setHorizontalAlignment(4);
        this.yAxisLabel.setLabelFor(this.yAxis);
        this.yAxisLabel.setText("Y-Axis");
        this.yAxis.setColumns(12);
        this.yAxis.setText("Y");
        GroupLayout plotLabelsPaneLayout = new GroupLayout((Container)this.plotLabelsPane);
        this.plotLabelsPane.setLayout((LayoutManager)plotLabelsPaneLayout);
        plotLabelsPaneLayout.setHorizontalGroup((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotLabelsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(2).add((Component)this.xAxisLabel).add((Component)this.yAxisLabel).add((Component)this.plotTitleLabel)).addPreferredGap(0).add((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(1, false).add((Component)this.plotTitle, -1, 136, Short.MAX_VALUE).add((Component)this.xAxis).add((Component)this.yAxis, -1, 136, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        plotLabelsPaneLayout.setVerticalGroup((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotLabelsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(3).add((Component)this.plotTitleLabel).add((Component)this.plotTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(3).add((Component)this.xAxisLabel).add((Component)this.xAxis, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(3).add((Component)this.yAxisLabel).add((Component)this.yAxis, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout((Container)this.plotPane);
        this.plotPane.setLayout((LayoutManager)plotPaneLayout);
        plotPaneLayout.setHorizontalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(2, false).add(1, (Component)this.plotOptionsPane, 0, 427, Short.MAX_VALUE).add(1, (GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.varPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.plotLabelsPane, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        plotPaneLayout.setVerticalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((Component)this.varPanel, -1, -1, Short.MAX_VALUE).add((Component)this.plotLabelsPane, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.plotOptionsPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 512) / 2, (screenSize.height - 460) / 2, 512, 460);
    }

    private void regLineCheckActionPerformed(ActionEvent evt) {
        this.refreshConfPredInt();
    }

    private void loessLineCheckActionPerformed(ActionEvent evt) {
        this.refreshConfPredInt();
    }

    protected void submitButtonAction() {
        PreferencesManager prefsManager = new PreferencesManager();
        try {
            prefsManager.importPreferences();
        }
        catch (Exception ex) {
            Logger.getLogger(ConditionalProbability.class.getName()).log(Level.INFO, null, ex);
        }
        String cmd = "scatterplot2.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", x=" + "'" + GUIUtils.getSelectedItem(this.xComboBox) + "'" + ", y=" + "'" + GUIUtils.getSelectedItem(this.yComboBox) + "'" + ", main=" + "'" + this.plotTitle.getText() + "'" + ", xlab=" + "'" + this.xAxis.getText() + "'" + ", ylab=" + "'" + this.yAxis.getText() + "'" + ", add.lm=" + String.valueOf(this.regLineCheck.isSelected()).toUpperCase() + ", add.loess=" + String.valueOf(this.loessLineCheck.isSelected()).toUpperCase() + ", add.conf=" + String.valueOf(this.confIntCheck.isSelected()).toUpperCase() + ", add.pred=" + String.valueOf(this.predIntCheck.isSelected()).toUpperCase() + ", conf=" + (Double)this.confLevelSpinner.getValue() + ", " + prefsManager.getCadstatPreferences().toString() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void helpButtonAction() {
        String cmd = "CADStat.help('scatterplot.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }
}

