/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRDataFileOpenDialog;

public class DatasetPane
extends JPanel {
    private JButton browseButton;
    private JComboBox datasetComboBox;
    private JLabel datasetLabel;

    public DatasetPane() {
        this.initComponents();
        this.refreshDatasetComboBox();
    }

    public String getSelectedDataset() {
        return GUIUtils.getSelectedItem(this.getDatasetComboBox());
    }

    public void refreshDatasetComboBox() {
        Object[] datasets = RUtils.getDatasetList();
        if (datasets != null && datasets.length > 0) {
            this.getDatasetComboBox().setModel(new DefaultComboBoxModel<Object>(datasets));
            this.getDatasetComboBox().setSelectedIndex(0);
        } else {
            this.getDatasetComboBox().removeAllItems();
        }
        this.refreshDatasetComboBoxValidity();
    }

    public void refreshDatasetComboBoxValidity() {
        this.getDatasetComboBox().setEnabled(this.getDatasetComboBox().getItemCount() > 0);
    }

    private void initComponents() {
        this.datasetLabel = new JLabel();
        this.datasetComboBox = new JComboBox();
        this.browseButton = new JButton();
        this.datasetLabel.setLabelFor(this.datasetComboBox);
        this.datasetLabel.setText("Dataset:");
        this.datasetComboBox.setPreferredSize(new Dimension(120, 24));
        this.browseButton.setText("Browse...");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetPane.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.datasetLabel).addPreferredGap(0).add((Component)this.datasetComboBox, -2, 176, -2).addPreferredGap(0).add((Component)this.browseButton)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.datasetLabel).add((Component)this.datasetComboBox, -2, -1, -2).add((Component)this.browseButton)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        new JGRDataFileOpenDialog((Frame)JGR.MAINRCONSOLE, RUtils.evalAsString("getwd()"));
        this.refreshDatasetComboBox();
        this.getDatasetComboBox().grabFocus();
    }

    public JComboBox getDatasetComboBox() {
        return this.datasetComboBox;
    }

    public void setDatasetComboBox(JComboBox datasetComboBox) {
        this.datasetComboBox = datasetComboBox;
    }

    public void setDatasetLabel(JLabel datasetLabel) {
        this.datasetLabel = datasetLabel;
    }

    public JLabel getDatasetLabel() {
        return this.datasetLabel;
    }
}

