/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class RegressionPrediction
extends DataPlotDialog {
    private String modelString;
    private JPanel analysisOptionsPane;
    public JRadioButton binomDistButton;
    private JComboBox dependentComboBox;
    private JLabel dependentLabel;
    private ButtonGroup distButtonGroup;
    private JPanel distPane;
    private JPanel idPane;
    private JLabel idVarLabel;
    private JComboBox idVarList;
    private JLabel independentLabel;
    private JList independentList;
    private JScrollPane independentScrollPane;
    private JPanel leftPane;
    private JPanel modelEqPane;
    private JScrollPane modelEqScrollPane;
    private JTextArea modelEqTextArea;
    public JRadioButton normDistButton;
    private JPanel plotPane;
    public JRadioButton poisDistButton;
    private JPanel rightPane;
    private JCheckBox rmIntercept;
    private JComboBox sampleSizeComboBox;
    private JLabel sampleSizeLabel;
    private JLabel sigLabel;
    private JSpinner sigLevel;
    private JLabel siteIDLabel;
    private JList siteIDValList;
    private JScrollPane siteIDValScrollPane;
    private JPanel siteSelPane;
    private JLabel siteVarLabel;
    private JComboBox siteVarList;
    private JPanel varPane;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getIdVarList().setModel(new DefaultComboBoxModel());
        this.getIdVarList().insertItemAt("", 0);
        this.getIdVarList().setSelectedIndex(0);
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegressionPrediction.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshSiteVarList();
        this.refreshIdVarList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshSiteVarList();
        this.refreshIdVarList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    public void refreshDistValidity() {
        Enumeration<AbstractButton> distButtonEnum = this.distButtonGroup.getElements();
        while (distButtonEnum.hasMoreElements()) {
            distButtonEnum.nextElement().setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0);
        }
    }

    public void refreshModelValidity() {
        this.refreshDistValidity();
        this.refreshVariableListValidity();
    }

    public void updateModelEquation() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            String modelEq = this.dependentComboBox.getSelectedItem() + " ~ " + RUtils.toString(this.independentList.getSelectedValues(), " + ", "");
            this.modelEqTextArea.setText(modelEq);
            if (this.binomDistButton.isSelected()) {
                this.setModelString(this.sampleSizeComboBox.getSelectedItem() + "," + this.dependentComboBox.getSelectedItem() + "," + RUtils.toString(this.independentList.getSelectedValues(), ",", ""));
            } else {
                this.setModelString(modelEq);
            }
        } else {
            this.setModelString(null);
            this.modelEqTextArea.setText(null);
        }
    }

    public void refreshVariableListValidity() {
        boolean datasetValid = this.getDatasetPane().getDatasetComboBox().getItemCount() > 0;
        this.dependentLabel.setEnabled(datasetValid && this.dependentComboBox.getItemCount() > 0);
        this.dependentComboBox.setEnabled(datasetValid && this.dependentComboBox.getItemCount() > 0);
        this.independentLabel.setEnabled(datasetValid && this.independentList.getModel().getSize() > 0);
        this.independentList.setEnabled(datasetValid && this.independentList.getModel().getSize() > 0);
        this.sampleSizeLabel.setEnabled(datasetValid && this.sampleSizeComboBox.getItemCount() > 0 && this.binomDistButton.isSelected());
        this.sampleSizeComboBox.setEnabled(datasetValid && this.sampleSizeComboBox.getItemCount() > 0 && this.binomDistButton.isSelected());
        this.siteVarLabel.setEnabled(datasetValid && this.siteVarList.getItemCount() > 0);
        this.siteVarList.setEnabled(datasetValid && this.siteVarList.getItemCount() > 0);
        this.siteIDLabel.setEnabled(datasetValid && this.siteIDValList.getModel().getSize() > 0);
        this.siteIDValList.setEnabled(datasetValid && this.siteIDValList.getModel().getSize() > 0);
        this.idVarLabel.setEnabled(datasetValid && this.idVarList.getItemCount() > 0);
        this.idVarList.setEnabled(datasetValid && this.idVarList.getItemCount() > 0);
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = null;
            Vector<String> onePlusNonFactors = null;
            Vector colNames = null;
            try {
                nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
                onePlusNonFactors = new Vector<String>(nonFactors.size() + 1);
                onePlusNonFactors.add("1");
                onePlusNonFactors.addAll(nonFactors);
                colNames = RUtils.colnamesVector(this.getDatasetPane().getSelectedDataset());
                this.dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
                this.sampleSizeComboBox.setModel(new DefaultComboBoxModel(onePlusNonFactors));
                if (colNames != null) {
                    this.independentList.setListData(colNames);
                } else {
                    this.independentList.removeAll();
                }
                if (this.dependentComboBox.getItemCount() > 0) {
                    this.dependentComboBox.setSelectedIndex(0);
                }
                if (this.sampleSizeComboBox.getItemCount() > 0) {
                    this.sampleSizeComboBox.setSelectedIndex(0);
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(RegressionPrediction.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(RegressionPrediction.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.dependentComboBox.removeAllItems();
            this.independentList.setModel(new DefaultListModel());
            this.sampleSizeComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    private void refreshSiteVarList() {
        JComboBox colList = this.getSiteVarList();
        String dataset = this.getDatasetPane().getSelectedDataset();
        if (dataset != null) {
            Vector factors = null;
            try {
                factors = RUtils.factors(dataset);
            }
            catch (REngineException ex) {
                Logger.getLogger(RegressionPrediction.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(RegressionPrediction.class.getName()).log(Level.SEVERE, null, ex);
            }
            colList.removeAllItems();
            colList.setModel(new DefaultComboBoxModel(factors));
        }
        this.refreshSiteValList();
    }

    private void refreshSiteValList() {
        block6: {
            String dataset = this.getDatasetPane().getSelectedDataset();
            Vector v = null;
            if (dataset != null && this.siteVarList.getItemCount() > 0) {
                String col = (String)this.siteVarList.getSelectedItem();
                String cmd = "unique(" + dataset + "$" + col + ")";
                try {
                    v = RUtils.evalAsVector(cmd);
                    if (v != null) {
                        this.siteIDValList.setListData(v);
                        this.siteIDValList.setSelectedIndex(0);
                        break block6;
                    }
                    this.siteIDValList.removeAll();
                }
                catch (REngineException ex) {
                    Logger.getLogger(RegressionPrediction.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (REXPMismatchException ex) {
                    Logger.getLogger(RegressionPrediction.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.siteIDValList.removeAll();
            }
        }
        this.refreshValidity();
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(this.siteVarList.getSelectedIndex() >= 0 && this.siteIDValList.getMaxSelectionIndex() >= 0 && !this.independentList.isSelectionEmpty());
    }

    public void refreshValidity() {
        this.refreshModelValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.distButtonGroup = new ButtonGroup();
        this.plotPane = new JPanel();
        this.modelEqPane = new JPanel();
        this.modelEqScrollPane = new JScrollPane();
        this.modelEqTextArea = new JTextArea();
        this.leftPane = new JPanel();
        this.distPane = new JPanel();
        this.normDistButton = new JRadioButton();
        this.poisDistButton = new JRadioButton();
        this.binomDistButton = new JRadioButton();
        this.varPane = new JPanel();
        this.dependentLabel = new JLabel();
        this.dependentComboBox = new JComboBox();
        this.independentLabel = new JLabel();
        this.independentScrollPane = new JScrollPane();
        this.independentList = new JList();
        this.sampleSizeLabel = new JLabel();
        this.sampleSizeComboBox = new JComboBox();
        this.rightPane = new JPanel();
        this.siteSelPane = new JPanel();
        this.siteVarLabel = new JLabel();
        this.siteVarList = new JComboBox();
        this.siteIDLabel = new JLabel();
        this.siteIDValScrollPane = new JScrollPane();
        this.siteIDValList = new JList();
        this.idPane = new JPanel();
        this.idVarLabel = new JLabel();
        this.idVarList = new JComboBox();
        this.analysisOptionsPane = new JPanel();
        this.sigLabel = new JLabel();
        this.sigLevel = new JSpinner();
        this.rmIntercept = new JCheckBox();
        this.modelEqPane.setBorder(BorderFactory.createTitledBorder("Model Equation"));
        this.modelEqTextArea.setColumns(20);
        this.modelEqTextArea.setEditable(false);
        this.modelEqTextArea.setLineWrap(true);
        this.modelEqTextArea.setRows(2);
        this.modelEqTextArea.setWrapStyleWord(true);
        this.modelEqScrollPane.setViewportView(this.modelEqTextArea);
        GroupLayout modelEqPaneLayout = new GroupLayout(this.modelEqPane);
        this.modelEqPane.setLayout(modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup(modelEqPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, modelEqPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqScrollPane, -1, 823, Short.MAX_VALUE).addContainerGap()));
        modelEqPaneLayout.setVerticalGroup(modelEqPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modelEqPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqScrollPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.distPane.setBorder(BorderFactory.createTitledBorder("Distribution"));
        this.distButtonGroup.add(this.normDistButton);
        this.normDistButton.setSelected(true);
        this.normDistButton.setText("Normal");
        this.normDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distButtonGroup.add(this.poisDistButton);
        this.poisDistButton.setText("Poisson");
        this.poisDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distButtonGroup.add(this.binomDistButton);
        this.binomDistButton.setText("Binomial");
        this.binomDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.binomDistButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RegressionPrediction.this.binomDistButtonStateChanged(evt);
            }
        });
        GroupLayout distPaneLayout = new GroupLayout(this.distPane);
        this.distPane.setLayout(distPaneLayout);
        distPaneLayout.setHorizontalGroup(distPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(distPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.normDistButton).addGap(18, 18, 18).addComponent(this.poisDistButton).addGap(18, 18, 18).addComponent(this.binomDistButton).addContainerGap(-1, Short.MAX_VALUE)));
        distPaneLayout.setVerticalGroup(distPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(distPaneLayout.createSequentialGroup().addContainerGap().addGroup(distPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.normDistButton).addComponent(this.poisDistButton).addComponent(this.binomDistButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.dependentLabel.setText("Dependent:");
        this.dependentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegressionPrediction.this.dependentComboBoxActionPerformed(evt);
            }
        });
        this.independentLabel.setText("Independent:");
        this.independentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RegressionPrediction.this.independentListValueChanged(evt);
            }
        });
        this.independentScrollPane.setViewportView(this.independentList);
        this.sampleSizeLabel.setText("Sample Size:");
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.sampleSizeLabel).addComponent(this.independentLabel).addComponent(this.dependentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.independentScrollPane, -1, 178, Short.MAX_VALUE).addComponent(this.sampleSizeComboBox, GroupLayout.Alignment.TRAILING, 0, 178, Short.MAX_VALUE).addComponent(this.dependentComboBox, GroupLayout.Alignment.TRAILING, 0, 178, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dependentComboBox, -2, -1, -2).addComponent(this.dependentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.independentLabel).addComponent(this.independentScrollPane, -1, 277, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sampleSizeComboBox, -2, -1, -2).addComponent(this.sampleSizeLabel)).addContainerGap()));
        GroupLayout leftPaneLayout = new GroupLayout(this.leftPane);
        this.leftPane.setLayout(leftPaneLayout);
        leftPaneLayout.setHorizontalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.distPane, -1, -1, Short.MAX_VALUE).addComponent(this.varPane, -1, -1, Short.MAX_VALUE));
        leftPaneLayout.setVerticalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPaneLayout.createSequentialGroup().addComponent(this.distPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.varPane, -1, -1, Short.MAX_VALUE)));
        this.siteSelPane.setBorder(BorderFactory.createTitledBorder("Reference Selection"));
        this.siteVarLabel.setText("Reference Variable:");
        this.siteVarList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegressionPrediction.this.siteVarListActionPerformed(evt);
            }
        });
        this.siteIDLabel.setText("Reference Data Values:");
        this.siteIDValList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RegressionPrediction.this.siteIDValListValueChanged(evt);
            }
        });
        this.siteIDValScrollPane.setViewportView(this.siteIDValList);
        GroupLayout siteSelPaneLayout = new GroupLayout(this.siteSelPane);
        this.siteSelPane.setLayout(siteSelPaneLayout);
        siteSelPaneLayout.setHorizontalGroup(siteSelPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(siteSelPaneLayout.createSequentialGroup().addContainerGap().addGroup(siteSelPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.siteIDLabel).addComponent(this.siteVarLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(siteSelPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteIDValScrollPane, -1, 254, Short.MAX_VALUE).addComponent(this.siteVarList, 0, 254, Short.MAX_VALUE)).addContainerGap()));
        siteSelPaneLayout.setVerticalGroup(siteSelPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(siteSelPaneLayout.createSequentialGroup().addContainerGap().addGroup(siteSelPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.siteVarLabel).addComponent(this.siteVarList, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(siteSelPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteIDLabel).addComponent(this.siteIDValScrollPane, -1, 216, Short.MAX_VALUE)).addContainerGap()));
        this.idPane.setBorder(BorderFactory.createTitledBorder("ID Variable"));
        this.idVarLabel.setText("Variable for Labels:");
        GroupLayout idPaneLayout = new GroupLayout(this.idPane);
        this.idPane.setLayout(idPaneLayout);
        idPaneLayout.setHorizontalGroup(idPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.idVarLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idVarList, 0, 291, Short.MAX_VALUE).addContainerGap()));
        idPaneLayout.setVerticalGroup(idPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idPaneLayout.createSequentialGroup().addContainerGap().addGroup(idPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idVarLabel).addComponent(this.idVarList, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.sigLabel.setText("Significance Level:");
        this.sigLevel.setModel(new SpinnerNumberModel(0.05, 0.01, 0.5, 0.01));
        this.rmIntercept.setText("Remove Intercept");
        GroupLayout analysisOptionsPaneLayout = new GroupLayout(this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout(analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.sigLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sigLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.rmIntercept).addContainerGap(-1, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sigLabel).addComponent(this.sigLevel, -2, -1, -2).addComponent(this.rmIntercept)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout rightPaneLayout = new GroupLayout(this.rightPane);
        this.rightPane.setLayout(rightPaneLayout);
        rightPaneLayout.setHorizontalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteSelPane, -1, -1, Short.MAX_VALUE).addGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.idPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.analysisOptionsPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)));
        rightPaneLayout.setVerticalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rightPaneLayout.createSequentialGroup().addComponent(this.siteSelPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.analysisOptionsPane, -2, -1, -2)));
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.modelEqPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, plotPaneLayout.createSequentialGroup().addComponent(this.leftPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightPane, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rightPane, -1, -1, Short.MAX_VALUE).addComponent(this.leftPane, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.setTitle("Regression Prediction");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 902) / 2, (screenSize.height - 831) / 2, 902, 831);
    }

    private void siteIDValListValueChanged(ListSelectionEvent evt) {
        this.refreshValidity();
    }

    private void siteVarListActionPerformed(ActionEvent evt) {
        this.refreshSiteValList();
    }

    private void binomDistButtonStateChanged(ChangeEvent evt) {
        this.sampleSizeLabel.setEnabled(this.binomDistButton.isSelected());
        this.sampleSizeComboBox.setEnabled(this.binomDistButton.isSelected());
        this.updateModelEquation();
    }

    private void dependentComboBoxActionPerformed(ActionEvent evt) {
        this.updateModelEquation();
    }

    private void independentListValueChanged(ListSelectionEvent evt) {
        this.updateModelEquation();
        this.refreshSubmitButtonValidity();
    }

    public JComboBox getIdVarList() {
        return this.idVarList;
    }

    public JComboBox getSiteVarList() {
        return this.siteVarList;
    }

    public Object[] getSiteValListSelectedValues() {
        return GUIUtils.getSelectedValues(this.siteIDValList);
    }

    private void refreshIdVarList() {
        JComboBox colList = this.getIdVarList();
        int m = colList.getItemCount();
        for (int k = 1; k < m; ++k) {
            colList.removeItemAt(1);
        }
        String dataset = this.getDatasetPane().getSelectedDataset();
        if (dataset != null) {
            String[] colnames = null;
            try {
                colnames = RUtils.colnames(dataset);
                int colLength = colnames.length;
                for (int k = 0; k < colLength; ++k) {
                    colList.insertItemAt(colnames[k], k + 1);
                }
                colList.setSelectedIndex(0);
            }
            catch (REngineException ex) {
                Logger.getLogger(RegressionPrediction.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(RegressionPrediction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    protected void submitButtonAction() {
        String distfamily = null;
        if (this.normDistButton.isSelected()) {
            distfamily = "gaussian";
        } else if (this.poisDistButton.isSelected()) {
            distfamily = "poisson";
        } else if (this.binomDistButton.isSelected()) {
            distfamily = "binomial";
        }
        String cmd = "glm.pred.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", site.name=" + "'" + this.getSiteVarList().getSelectedItem().toString() + "'" + ", site.val=" + "c(" + RUtils.toString(this.getSiteValListSelectedValues(), ",", "'") + ")" + ", my.formula=" + "'" + this.getModelString() + "'" + ", my.family=" + "'" + distfamily + "'" + ", label.name=" + "'" + this.idVarList.getSelectedItem() + "'" + ", sig.level=" + (Double)this.sigLevel.getValue() + ", iRmIntercept=" + String.valueOf(this.rmIntercept.isSelected()).toUpperCase() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('glm.pred.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    public String getModelString() {
        return this.modelString;
    }

    public void setModelString(String modelString) {
        this.modelString = modelString;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object dep = this.dependentComboBox.getSelectedItem();
        int[] indepIndices = this.independentList.getSelectedIndices();
        Object sampleSize = this.sampleSizeComboBox.getSelectedItem();
        Object refVar = this.siteVarList.getSelectedItem();
        int[] refValues = this.siteIDValList.getSelectedIndices();
        Object idVar = this.idVarList.getSelectedItem();
        this.getDatasetPane().refreshDatasetComboBox();
        this.refreshFactorSelectionPanes();
        this.dependentComboBox.setSelectedItem(dep);
        this.independentList.setSelectedIndices(indepIndices);
        this.sampleSizeComboBox.setSelectedItem(sampleSize);
        this.siteVarList.setSelectedItem(refVar);
        this.siteIDValList.setSelectedIndices(refValues);
        this.idVarList.setSelectedItem(idVar);
        this.updateModelEquation();
        this.refreshValidity();
    }
}

