% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_plot.r
\name{CoUMAP.plot}
\alias{CoUMAP.plot}
\title{Plot Co-embedding UMAP for Genes and Cells}
\usage{
CoUMAP.plot(
  seu,
  reduction = "caesarUMAP",
  gene_txtdata = NULL,
  ident = NULL,
  xy_name = reduction,
  dims = c(1, 2),
  cols = NULL,
  shape_cg = c(1, 5),
  pt_size = 1,
  pt_text_size = 5,
  base_size = 16,
  base_family = "serif",
  legend.point.size = 5,
  legend.key.size = 1.5,
  alpha = 0.8
)
}
\arguments{
\item{seu}{A Seurat object containing the co-embedding data.}

\item{reduction}{A character string specifying the name of the dimensional reduction to use for the UMAP plot. Default is "caesarUMAP".}

\item{gene_txtdata}{A data frame containing gene names and labels to display as text on the plot. If \code{NULL}, no text labels are shown. Default is \code{NULL}.}

\item{ident}{A character string specifying the column name in the Seurat object's metadata that contains cell type or cluster labels. If \code{NULL}, the default identities (\code{Idents(seu)}) are used. Default is \code{NULL}.}

\item{xy_name}{A character string specifying the prefix for the UMAP axes. Default is the value of \code{reduction}.}

\item{dims}{A numeric vector of length 2 specifying which dimensions to plot. Default is \code{c(1, 2)}.}

\item{cols}{A named vector of colors for clusters. If \code{NULL}, default colors are generated. Default is \code{NULL}.}

\item{shape_cg}{A numeric vector of length 2 specifying the shapes for cells and genes. Default is \code{c(1, 5)}.}

\item{pt_size}{Numeric, specifying the size of the points for cells and genes. Default is 1.}

\item{pt_text_size}{Numeric, specifying the size of the text labels for genes. Default is 5.}

\item{base_size}{Numeric, specifying the base font size for the plot. Default is 16.}

\item{base_family}{Character string specifying the font family for the plot. Default is "serif".}

\item{legend.point.size}{Numeric, specifying the size of the points in the legend. Default is 5.}

\item{legend.key.size}{Numeric, specifying the size of the legend keys. Default is 1.5.}

\item{alpha}{Numeric, specifying the transparency level for cell points. Default is 0.8.}
}
\value{
A ggplot object representing the UMAP plot.
}
\description{
This function generates a UMAP plot for co-embedding genes and cells in a Seurat object. It allows for customization of point colors, shapes, and text labels, and can display both gene and cell embeddings in the same plot.
}
\details{
The function creates a UMAP plot that shows both gene and cell embeddings. Gene embeddings can be optionally labeled with text, and the plot can be customized with different colors, shapes, and sizes.
}
\examples{
data(toydata)

seu <- toydata$seu

seu <- CoUMAP(seu, gene.set = rownames(seu))
CoUMAP.plot(seu)

}
\seealso{
\code{\link{CoUMAP}} for obtain co-embedding UMAP.
}
