% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_instances.R
\name{calc_instances}
\alias{calc_instances}
\title{Calculates number of instances for the comparison of two algorithms}
\usage{
calc_instances(ninstances = NULL, power = NULL, d, sig.level = 0.05,
  alternative = "two.sided", test.type = "t.test")
}
\arguments{
\item{ninstances}{the number of instances to be used in the experiment.}

\item{power}{(desired) test power}

\item{d}{minimally relevant effect size (MRES, expressed as a standardized
effect size, i.e., "deviation from H0" / "standard deviation")}

\item{sig.level}{significance level (alpha) for the experiment}

\item{alternative}{type of alternative hypothesis ("two.sided" or
"one.sided")}

\item{test.type}{type of test ("t.test", "wilcoxon", "binomial")}
}
\value{
a list object containing the following items:
\itemize{
\item \code{ninstances} - number of instances
\item \code{power} - the power of the comparison
\item \code{d} - the effect size
\item \code{sig.level} - significance level
\item \code{alternative} - type of alternative hypothesis
\item \code{test.type} - type of test
}
}
\description{
Calculates either the number of instances, the standardized effect size, or
the power of a comparison of two algorithms
}
\details{
This routine uses the closed formula of the t-test to calculate the number
of instances required for a comparison of two algorithms, considering a
desired power, standardized effect size, and significance level.
for cases where the number of instances is predefined, it can return the
test power instead.
}
\section{Sample Sizes for Nonparametric Methods}{

If the parameter \code{test.type} is set to either \code{Wilcoxon} or \code{Binomial}, this
routine approximates the number of instances using the ARE of these tests
in relation to the paired t.test, using the formulas:
\itemize{
\item \deqn{n.wilcox = n.ttest / 0.86 = 1.163 * n.ttest}
\item \deqn{n.binom = n.ttest / 0.637 = 1.570 * n.ttest}
}
}

\author{
Felipe Campelo (\email{fcampelo@ufmg.br}),
Fernanda Takahashi (\email{fernandact@ufmg.br})
}
