% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_param.R
\name{se_param}
\alias{se_param}
\title{Parametric standard errors}
\usage{
se_param(x1, x2, dif, ...)
}
\arguments{
\item{x1}{vector of observations}

\item{x2}{vector of observations}

\item{dif}{name of the difference for which the SE is desired. Accepts
"simple" (simple differences) or "perc" (percent differences).}

\item{...}{other parameters (used only for compatibility with calls to
\code{\link[=se_boot]{se_boot()}}, unused in this function)}
}
\value{
estimated standard error
}
\description{
Calculates the standard error of a given statistic using parametric formulas
}
\section{References}{

\itemize{
\item E.C. Fieller:
Some problems in interval estimation. Journal of the Royal Statistical
Society. Series B (Methodological) 16(2), 175–185 (1954)
\item V. Franz:
Ratios: A short guide to confidence limits and proper use (2007).
https://arxiv.org/pdf/0710.2024v1.pdf
\item D.C. Montgomery, C.G. Runger:
Applied Statistics and Probability for Engineers, 6th ed. Wiley (2013)
\item F. Campelo, F. Takahashi:
Sample size estimation for power and accuracy in the experimental
comparison of algorithms (submitted, 2017).
}
}

\examples{
# two vectors of normally distributed observations
set.seed(1234)
x1 <- rnorm(100, 5, 1)  # mean = 5, sd = 1
x2 <- rnorm(200, 10, 2) # mean = 10, sd = 2

# Theoretical SE for simple difference: 0.1732051
se_param(x1, x2, dif = "simple")

# Theoretical (Fieller, no covariance) SE for percent differences: 0.04
se_param(x1, x2, dif = "perc")
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br})
}
