% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_SANN.R
\name{example_SANN}
\alias{example_SANN}
\title{Simulated annealing (for testing/examples)}
\usage{
example_SANN(Temp, budget, instance)
}
\arguments{
\item{Temp}{controls the "SANN" method. It is the starting temperature for
the cooling schedule.}

\item{budget}{stop criterion: number of function evaluations to execute}

\item{instance}{an instance object (see \code{\link[=calc_nreps]{calc_nreps()}} for details)}
}
\description{
Adapted from stats::optim(). Check their documentation / examples for
details.
}
\examples{
\dontrun{
instance <- list(FUN = "TSP.dist", mydist = datasets::eurodist)

example_SANN(Temp = 2000, budget = 10000, instance = instance)
}


}
