% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateSpacetimeFolds.R
\name{CreateSpacetimeFolds}
\alias{CreateSpacetimeFolds}
\title{Create Space-time Folds}
\usage{
CreateSpacetimeFolds(
  x,
  spacevar = NA,
  timevar = NA,
  k = 10,
  class = NA,
  seed = sample(1:1000, 1)
)
}
\arguments{
\item{x}{data.frame containing spatio-temporal data}

\item{spacevar}{Character indicating which column of x identifies the
spatial units (e.g. ID of weather stations)}

\item{timevar}{Character indicating which column of x identifies the
temporal units (e.g. the day of the year)}

\item{k}{numeric. Number of folds. If spacevar or timevar is NA and a
leave one location out or leave one time step out cv should be performed,
set k to the number of unique spatial or temporal units.}

\item{class}{Character indicating which column of x identifies a class unit (e.g. land cover)}

\item{seed}{numeric. See ?seed}
}
\value{
A list that contains a list for model training and a list for
model validation that can directly be used as "index" and "indexOut" in
caret's trainControl function
}
\description{
Create spatial, temporal or spatio-temporal Folds for cross validation
}
\details{
Using "class" is helpful in the case that data are clustered in space
and are categorical. E.g This is the case for land cover classifications when
training data come as training polygons. In this case the data should be split in a way
that entire polygons are held back (spacevar="polygonID") but at the same time the distribution of classes
should be similar in each fold (class="LUC").
}
\note{
Standard k-fold cross-validation can lead to considerable misinterpretation in spatial-temporal modelling tasks. This function can be used to prepare a Leave-Location-Out, Leave-Time-Out or Leave-Location-and-Time-Out cross-validation as target-oriented validation strategies for spatial-temporal prediction tasks. See Meyer et al. (2018) for further information.
}
\examples{
library(GSIF)
data(cookfarm)
### Prepare for 10-fold Leave-Location-and-Time-Out cross validation
indices <- CreateSpacetimeFolds(cookfarm$readings,"SOURCEID","Date")
str(indices)
### Prepare for 10-fold Leave-Location-Out cross validation
indices <- CreateSpacetimeFolds(cookfarm$readings,spacevar="SOURCEID")
str(indices)
### Prepare for leave-One-Location-Out cross validation
indices <- CreateSpacetimeFolds(cookfarm$readings,spacevar="SOURCEID",
k=length(unique(cookfarm$readings$SOURCEID)))
str(indices)
}
\references{
Meyer, H., Reudenbach, C., Hengl, T., Katurji, M., Nauß, T. (2018): Improving performance of spatio-temporal machine learning models using forward feature selection and target-oriented validation. Environmental Modelling & Software 101: 1-9.
}
\seealso{
\code{\link{trainControl}},\code{\link{ffs}}
}
\author{
Hanna Meyer
}
