% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_aoa.R
\name{calibrate_aoa}
\alias{calibrate_aoa}
\title{Calibrate the AOA based on the relationship between the DI and the prediction error}
\usage{
calibrate_aoa(
  AOA,
  model,
  window.size = 5,
  calib = "scam",
  multiCV = FALSE,
  length.out = 10,
  maskAOA = TRUE,
  showPlot = TRUE,
  k = 6,
  m = 2
)
}
\arguments{
\item{AOA}{the result of \code{\link{aoa}}}

\item{model}{the model used to get the AOA}

\item{window.size}{Numeric. Size of the moving window. See \code{\link{rollapply}}.}

\item{calib}{Character. Function to model the DI~performance relationship. Currently lm and scam are supported}

\item{multiCV}{Logical. Re-run model fitting and validation with different CV strategies. See details.}

\item{length.out}{Numeric. Only used if multiCV=TRUE. Number of cross-validation folds. See details.}

\item{maskAOA}{Logical. Should areas outside the AOA set to NA?}

\item{showPlot}{Logical.}

\item{k}{Numeric. See mgcv::s}

\item{m}{Numeric. See mgcv::s}
}
\value{
A list of length 2 with the elements "AOA": rasterStack which contains the original DI and the AOA (which might be updated if new test data indicate this option), as well as the expected performance based on the relationship.
Data used for calibration are stored in the attributes. The second element is a plot showing the relationship.
}
\description{
Performance metrics are calculated for moving windows of DI values of cross-validated training data
}
\details{
If multiCV=TRUE the model is re-fitted and validated by length.out new cross-validations where the cross-validation folds are defined by clusters in the predictor space,
ranging from three clusters to LOOCV. Hence, a large range of DI values is created during cross-validation.
If the AOA threshold based on the calibration data from multiple CV is larger than the original AOA threshold (which is likely if extrapolation situations are created during CV),
the AOA is updated accordingly. See Meyer and Pebesma (2021) for the full documentation of the methodology.
}
\examples{
\dontrun{
library(sf)
library(raster)
library(caret)
library(viridis)
library(latticeExtra)

# prepare sample data:
library(sf)
library(raster)
library(caret)
# prepare sample data:
dat <- get(load(system.file("extdata","Cookfarm.RData",package="CAST")))
dat <- aggregate(dat[,c("VW","Easting","Northing")],by=list(as.character(dat$SOURCEID)),mean)
pts <- st_as_sf(dat,coords=c("Easting","Northing"))
pts$ID <- 1:nrow(pts)
studyArea <- stack(system.file("extdata","predictors_2012-03-25.grd",package="CAST"))[[1:8]]
dat <- extract(studyArea,pts,df=TRUE)
trainDat <- merge(dat,pts,by.x="ID",by.y="ID")

# train a model:
variables <- c("DEM","NDRE.Sd","TWI")
set.seed(100)
model <- train(trainDat[,which(names(trainDat)\%in\%variables)],
  trainDat$VW,method="rf",importance=TRUE,tuneLength=1,
  trControl=trainControl(method="cv",number=5,savePredictions=TRUE))

#...then calculate the AOA of the trained model for the study area:
AOA <- aoa(studyArea,model)

AOA_new <- calibrate_aoa(AOA,model)
plot(AOA_new$AOA$expected_RMSE)
# attributes(AOA_new$AOA) # data used for calibration
}
}
\references{
Meyer, H., Pebesma, E. (2021): Predicting into unknown space?
Estimating the area of applicability of spatial prediction models.
\doi{10.1111/2041-210X.13650}
}
\seealso{
\code{\link{aoa}}
}
\author{
Hanna Meyer
}
