% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seabed_area.R
\name{seabed_area}
\alias{seabed_area}
\title{Calculate planimetric seabed area}
\usage{
seabed_area(Bathy, Poly, PolyNames = NULL, depth_classes = c(-600, -1800))
}
\arguments{
\item{Bathy}{bathymetry raster with the appropriate \code{\link[CCAMLRGIS:CCAMLRp]{projection}}.
It is highly recommended to use a raster of higher
resolution than \code{\link{SmallBathy}}, see \code{\link{load_Bathy}}.}

\item{Poly}{polygon(s) within which the areas of depth strata are computed.}

\item{PolyNames}{character, column name (from the polygon object) to be used in the output.}

\item{depth_classes}{numeric vector of strata depths. for example, \code{depth_classes=c(-600,-1000,-2000)}.
If the values \code{-600,-1800} are given within \code{depth_classes}, the computed area will be labelled as 'Fishable_area'.}
}
\value{
dataframe with the name of polygons in the first column and the area for each strata in the following columns.
}
\description{
Calculate planimetric seabed area within polygons and depth strata in square kilometers.
}
\examples{
\donttest{

#create some polygons
MyPolys=create_Polys(PolyData,Densify=TRUE)
#compute the seabed areas
FishDepth=seabed_area(SmallBathy,MyPolys,PolyNames="ID",
depth_classes=c(0,-200,-600,-1800,-3000,-5000))
#Result looks like this (note that the 600-1800 stratum is renamed 'Fishable_area')
#View(FishDepth)


}

}
\seealso{
\code{\link{load_Bathy}}, \code{\link{SmallBathy}}, \code{\link{create_Polys}}, \code{\link{load_RBs}}.
}
