% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stations.R
\name{cdec_stations}
\alias{cdec_stations}
\title{Search CDEC Stations}
\usage{
cdec_stations(station_id = NULL, nearby_city = NULL,
  river_basin = NULL, hydro_area = NULL, county = NULL)
}
\arguments{
\item{station_id}{string three letter station code}

\item{nearby_city}{string search stations near supplied city}

\item{river_basin}{string search stations in supplied basin}

\item{hydro_area}{string search stations in supplied hydrological area}

\item{county}{string search stations in supplied county}
}
\description{
search the stations in thec CDEC system using the CDEC Station Search
service \href{https://cdec.water.ca.gov/cgi-progs/staSearch}{here}. Combinations
of these parameters can be supplied to refine or be left out to generalize, at least
one must be supplied.
}
\examples{
# cdec_stations() can be used to find locations within an area of interest
cdec_stations(county = "alameda")
# or it can be used to get metadata attributes for a location
cdec_stations(station_id = "ccr")
}
