% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-functions.R
\name{datediff}
\alias{datediff}
\title{Compute the difference between two days}
\usage{
datediff(start, end, interval = "day")
}
\arguments{
\item{start}{The name of the start date column in the database as a string.}

\item{end}{The name of the end date column in the database as a string.}

\item{interval}{The units to use for difference calculation. Must be either "day" (default) or "year".}
}
\value{
Platform specific SQL that can be used in a dplyr query.
}
\description{
This function must be "unquoted" using the "bang bang" operator (!!). See example.
}
\examples{
\dontrun{
library(SqlUtilities)
con <- DBI::dbConnect(duckdb::duckdb())
date_tbl <- dplyr::copy_to(con, data.frame(date1 = as.Date("1999-01-01")),
                           name = "tmpdate", overwrite = TRUE, temporary = TRUE)

df <- date_tbl \%>\%
  dplyr::mutate(date2 = !!dateadd("date1", 1, interval = "year")) \%>\%
  dplyr::mutate(dif_years = !!datediff("date1", "date2", interval = "year")) \%>\%
  dplyr::collect()

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
