% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Eunomia.R
\name{eunomiaDir}
\alias{eunomiaDir}
\alias{eunomia_dir}
\title{Create a copy of an example OMOP CDM dataset}
\usage{
eunomiaDir(
  datasetName = "GiBleed",
  cdmVersion = "5.3",
  databaseFile = tempfile(fileext = ".duckdb")
)

eunomia_dir(
  dataset_name = "GiBleed",
  cdm_version = "5.3",
  database_file = tempfile(fileext = ".duckdb")
)
}
\arguments{
\item{datasetName, dataset_name}{One of "GiBleed" (default),
"synthea-allergies-10k",
"synthea-anemia-10k",
"synthea-breast_cancer-10k",
"synthea-contraceptives-10k",
"synthea-covid19-10k",
"synthea-covid19-200k",
"synthea-dermatitis-10k",
"synthea-heart-10k",
"synthea-hiv-10k",
"synthea-lung_cancer-10k",
"synthea-medications-10k",
"synthea-metabolic_syndrome-10k",
"synthea-opioid_addiction-10k",
"synthea-rheumatoid_arthritis-10k",
"synthea-snf-10k",
"synthea-surgery-10k",
"synthea-total_joint_replacement-10k",
"synthea-veteran_prostate_cancer-10k",
"synthea-veterans-10k",
"synthea-weight_loss-10k"}

\item{cdmVersion, cdm_version}{The OMOP CDM version. Currently only "5.3" is supported.}

\item{databaseFile, database_file}{The full path to the new copy of the example CDM dataset.}
}
\value{
The file path to the new Eunomia dataset copy
}
\description{
Creates a copy of a Eunomia database, and returns the path to the new database file.
If the dataset does not yet exist on the user's computer it will attempt to download the source data
to the the path defined by the EUNOMIA_DATA_FOLDER environment variable.
}
\examples{
\dontrun{
 con <- DBI::dbConnect(duckdb::duckdb(), eunomiaDir("GiBleed"))
 DBI::dbDisconnect(con, shutdown = TRUE)
}
}
