% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeasonalFilter.R
\name{SeasonalTimerange}
\alias{SeasonalTimerange}
\title{Create seasonal time range}
\usage{
SeasonalTimerange(from, to)
}
\arguments{
\item{from}{start of the season of interest.}

\item{to}{end of the season of interest.

The \code{from} and \code{to} arguments can be either Date or character that can be converted to date by \code{as.Date}.
    Open intervals are not allowed (both \code{from} and \code{to} must be valid dates).}
}
\value{
A list of time ranges defining the season of interest for each year.
}
\description{
Creates list of seasonal filters (one per year) for the season of interest -
   dates between \code{from} day/month and \code{to} day/month for all years in the
   \code{from} - \code{to} time range.
}
\examples{
\dontrun{
seasons <- SeasonalTimerange(from = "2020-05-01", to = "2023-09-30")
seasons <- SeasonalTimerange(from = "2019-11-01", to = "2023-03-30")
}
}
