% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{sentence_eval}
\alias{sentence_eval}
\title{Evaluate One Sentence}
\usage{
sentence_eval(
  unique_id,
  unique_sentences,
  annotations,
  query_vect,
  keyword_mask,
  keyword_elements,
  cui_mask,
  cui_elements,
  use_negation
)
}
\arguments{
\item{unique_id}{Sentence ID, i.e. row number in annotations dataframe.}

\item{unique_sentences}{Dataframe of unique sentences for the patient.}

\item{annotations}{NLP annotation dataframe.}

\item{query_vect}{Vector of search query components.}

\item{keyword_mask}{Query vector with only keywords.}

\item{keyword_elements}{Vector of search query keywords.}

\item{cui_mask}{Query vector with only CUI's.}

\item{cui_elements}{Vector of search query CUI's.}

\item{use_negation}{Should negated items be ignored in the keyword/concept search?}
}
\value{
If sentence matches query, returns sentences with marked tokens/CUI's, otherwise NA.
}
\description{
Assesses if one sentence matches the search query and marks positive tokens/concept unique identifiers (CUI's).
}
\keyword{internal}
