% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/permutationDistances.r
\name{distancePermutationPosition2}
\alias{distancePermutationPosition2}
\title{Squared Position Distance for Permutations}
\usage{
distancePermutationPosition2(x, y)
}
\arguments{
\item{x}{first permutation (integer vector)}

\item{y}{second permutation (integer vector)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1 (based on the maximum possible distance between two permutations)
}
\description{
Squared position distance (or Spearmans Footrule), scaled to values between 0 and 1.
}
\examples{
x <- 1:5
y <- c(1,3,5,4,2)
distancePermutationPosition2(x,y)
p <- replicate(10,sample(1:5),simplify=FALSE)
distanceMatrix(p,distancePermutationPosition2)
}
\references{
Schiavinotto, Tommaso, and Thomas Stuetzle. "A review of metrics on permutations for search landscape analysis." Computers & operations research 34.10 (2007): 3143-3153.

Reeves, Colin R. "Landscapes, operators and heuristic search." Annals of Operations Research 86 (1999): 473-490.
}

